package zio.aws.cloud9.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnvironmentLifecycle(
    status: Option[zio.aws.cloud9.model.EnvironmentLifecycleStatus] = None,
    reason: Option[String] = None,
    failureResource: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.EnvironmentLifecycle = {
    import EnvironmentLifecycle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.EnvironmentLifecycle
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(failureResource.map(value => value: java.lang.String))(
        _.failureResource
      )
      .build()
  }
  def asReadOnly: zio.aws.cloud9.model.EnvironmentLifecycle.ReadOnly =
    zio.aws.cloud9.model.EnvironmentLifecycle.wrap(buildAwsValue())
}
object EnvironmentLifecycle {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.EnvironmentLifecycle
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.EnvironmentLifecycle =
      zio.aws.cloud9.model.EnvironmentLifecycle(
        status.map(value => value),
        reason.map(value => value),
        failureResource.map(value => value)
      )
    def status: Option[zio.aws.cloud9.model.EnvironmentLifecycleStatus]
    def reason: Option[String]
    def failureResource: Option[String]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cloud9.model.EnvironmentLifecycleStatus] =
      AwsError.unwrapOptionField("status", status)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getFailureResource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureResource", failureResource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.EnvironmentLifecycle
  ) extends zio.aws.cloud9.model.EnvironmentLifecycle.ReadOnly {
    override val status
        : Option[zio.aws.cloud9.model.EnvironmentLifecycleStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.cloud9.model.EnvironmentLifecycleStatus.wrap(value))
    override val reason: Option[String] =
      scala.Option(impl.reason()).map(value => value: String)
    override val failureResource: Option[String] =
      scala.Option(impl.failureResource()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.EnvironmentLifecycle
  ): zio.aws.cloud9.model.EnvironmentLifecycle.ReadOnly = new Wrapper(impl)
}
