package zio.aws.cloud9.model
import java.lang.Integer
import zio.aws.cloud9.model.primitives.{MaxResults, EnvironmentId, UserArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEnvironmentMembershipsRequest(
    userArn: Option[UserArn] = None,
    environmentId: Option[EnvironmentId] = None,
    permissions: Option[Iterable[zio.aws.cloud9.model.Permissions]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest = {
    import DescribeEnvironmentMembershipsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest
      .builder()
      .optionallyWith(
        userArn.map(value => UserArn.unwrap(value): java.lang.String)
      )(_.userArn)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithStrings)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.cloud9.model.DescribeEnvironmentMembershipsRequest.ReadOnly =
    zio.aws.cloud9.model.DescribeEnvironmentMembershipsRequest
      .wrap(buildAwsValue())
}
object DescribeEnvironmentMembershipsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.DescribeEnvironmentMembershipsRequest =
      zio.aws.cloud9.model.DescribeEnvironmentMembershipsRequest(
        userArn.map(value => value),
        environmentId.map(value => value),
        permissions.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def userArn: Option[UserArn]
    def environmentId: Option[EnvironmentId]
    def permissions: Option[List[zio.aws.cloud9.model.Permissions]]
    def nextToken: Option[String]
    def maxResults: Option[MaxResults]
    def getUserArn: ZIO[Any, AwsError, UserArn] =
      AwsError.unwrapOptionField("userArn", userArn)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getPermissions
        : ZIO[Any, AwsError, List[zio.aws.cloud9.model.Permissions]] =
      AwsError.unwrapOptionField("permissions", permissions)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest
  ) extends zio.aws.cloud9.model.DescribeEnvironmentMembershipsRequest.ReadOnly {
    override val userArn: Option[UserArn] = scala
      .Option(impl.userArn())
      .map(value => zio.aws.cloud9.model.primitives.UserArn(value))
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value => zio.aws.cloud9.model.primitives.EnvironmentId(value))
    override val permissions: Option[List[zio.aws.cloud9.model.Permissions]] =
      scala
        .Option(impl.permissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloud9.model.Permissions.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.cloud9.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest
  ): zio.aws.cloud9.model.DescribeEnvironmentMembershipsRequest.ReadOnly =
    new Wrapper(impl)
}
