package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateVoiceConnectorGroupResponse(
    voiceConnectorGroup: Optional[
      zio.aws.chimesdkvoice.model.VoiceConnectorGroup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse = {
    import UpdateVoiceConnectorGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse
      .builder()
      .optionallyWith(voiceConnectorGroup.map(value => value.buildAwsValue()))(
        _.voiceConnectorGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse
      .wrap(buildAwsValue())
}
object UpdateVoiceConnectorGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse =
      zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse(
        voiceConnectorGroup.map(value => value.asEditable)
      )
    def voiceConnectorGroup
        : Optional[zio.aws.chimesdkvoice.model.VoiceConnectorGroup.ReadOnly]
    def getVoiceConnectorGroup: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceConnectorGroup.ReadOnly
    ] = AwsError.unwrapOptionField("voiceConnectorGroup", voiceConnectorGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse
  ) extends zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse.ReadOnly {
    override val voiceConnectorGroup
        : Optional[zio.aws.chimesdkvoice.model.VoiceConnectorGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnectorGroup())
        .map(value =>
          zio.aws.chimesdkvoice.model.VoiceConnectorGroup.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse
  ): zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse.ReadOnly =
    new Wrapper(impl)
}
