package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.DataRetentionInHours
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StreamingConfiguration(
    dataRetentionInHours: DataRetentionInHours,
    disabled: Boolean,
    streamingNotificationTargets: Optional[
      Iterable[zio.aws.chimesdkvoice.model.StreamingNotificationTarget]
    ] = Optional.Absent,
    mediaInsightsConfiguration: Optional[
      zio.aws.chimesdkvoice.model.MediaInsightsConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.StreamingConfiguration = {
    import StreamingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.StreamingConfiguration
      .builder()
      .dataRetentionInHours(
        DataRetentionInHours.unwrap(dataRetentionInHours): Integer
      )
      .disabled(disabled: java.lang.Boolean)
      .optionallyWith(
        streamingNotificationTargets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streamingNotificationTargets)
      .optionallyWith(
        mediaInsightsConfiguration.map(value => value.buildAwsValue())
      )(_.mediaInsightsConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.StreamingConfiguration.ReadOnly =
    zio.aws.chimesdkvoice.model.StreamingConfiguration.wrap(buildAwsValue())
}
object StreamingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.StreamingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.StreamingConfiguration =
      zio.aws.chimesdkvoice.model.StreamingConfiguration(
        dataRetentionInHours,
        disabled,
        streamingNotificationTargets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        mediaInsightsConfiguration.map(value => value.asEditable)
      )
    def dataRetentionInHours: DataRetentionInHours
    def disabled: Boolean
    def streamingNotificationTargets: Optional[
      List[zio.aws.chimesdkvoice.model.StreamingNotificationTarget.ReadOnly]
    ]
    def mediaInsightsConfiguration: Optional[
      zio.aws.chimesdkvoice.model.MediaInsightsConfiguration.ReadOnly
    ]
    def getDataRetentionInHours: ZIO[Any, Nothing, DataRetentionInHours] =
      ZIO.succeed(dataRetentionInHours)
    def getDisabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(disabled)
    def getStreamingNotificationTargets: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.StreamingNotificationTarget.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "streamingNotificationTargets",
      streamingNotificationTargets
    )
    def getMediaInsightsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.MediaInsightsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mediaInsightsConfiguration",
      mediaInsightsConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.StreamingConfiguration
  ) extends zio.aws.chimesdkvoice.model.StreamingConfiguration.ReadOnly {
    override val dataRetentionInHours: DataRetentionInHours =
      zio.aws.chimesdkvoice.model.primitives
        .DataRetentionInHours(impl.dataRetentionInHours())
    override val disabled: Boolean = impl.disabled(): Boolean
    override val streamingNotificationTargets: Optional[
      List[zio.aws.chimesdkvoice.model.StreamingNotificationTarget.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.streamingNotificationTargets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.StreamingNotificationTarget.wrap(item)
        }.toList
      )
    override val mediaInsightsConfiguration: Optional[
      zio.aws.chimesdkvoice.model.MediaInsightsConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaInsightsConfiguration())
      .map(value =>
        zio.aws.chimesdkvoice.model.MediaInsightsConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.StreamingConfiguration
  ): zio.aws.chimesdkvoice.model.StreamingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
