package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.{
  ClientRequestId,
  NonEmptyString256,
  NonEmptyString128
}
import scala.jdk.CollectionConverters._
final case class StartVoiceToneAnalysisTaskRequest(
    voiceConnectorId: NonEmptyString128,
    transactionId: NonEmptyString256,
    languageCode: zio.aws.chimesdkvoice.model.LanguageCode,
    clientRequestToken: Optional[ClientRequestId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.StartVoiceToneAnalysisTaskRequest = {
    import StartVoiceToneAnalysisTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.StartVoiceToneAnalysisTaskRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString128.unwrap(voiceConnectorId): java.lang.String
      )
      .transactionId(NonEmptyString256.unwrap(transactionId): java.lang.String)
      .languageCode(languageCode.unwrap)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestId.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.StartVoiceToneAnalysisTaskRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.StartVoiceToneAnalysisTaskRequest
      .wrap(buildAwsValue())
}
object StartVoiceToneAnalysisTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.StartVoiceToneAnalysisTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.StartVoiceToneAnalysisTaskRequest =
      zio.aws.chimesdkvoice.model.StartVoiceToneAnalysisTaskRequest(
        voiceConnectorId,
        transactionId,
        languageCode,
        clientRequestToken.map(value => value)
      )
    def voiceConnectorId: NonEmptyString128
    def transactionId: NonEmptyString256
    def languageCode: zio.aws.chimesdkvoice.model.LanguageCode
    def clientRequestToken: Optional[ClientRequestId]
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(voiceConnectorId)
    def getTransactionId: ZIO[Any, Nothing, NonEmptyString256] =
      ZIO.succeed(transactionId)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.chimesdkvoice.model.LanguageCode] =
      ZIO.succeed(languageCode)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestId] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.StartVoiceToneAnalysisTaskRequest
  ) extends zio.aws.chimesdkvoice.model.StartVoiceToneAnalysisTaskRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString128 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString128(impl.voiceConnectorId())
    override val transactionId: NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString256(impl.transactionId())
    override val languageCode: zio.aws.chimesdkvoice.model.LanguageCode =
      zio.aws.chimesdkvoice.model.LanguageCode.wrap(impl.languageCode())
    override val clientRequestToken: Optional[ClientRequestId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.ClientRequestId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.StartVoiceToneAnalysisTaskRequest
  ): zio.aws.chimesdkvoice.model.StartVoiceToneAnalysisTaskRequest.ReadOnly =
    new Wrapper(impl)
}
