package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SipMediaApplicationLoggingConfiguration(
    enableSipMediaApplicationMessageLogs: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration = {
    import SipMediaApplicationLoggingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration
      .builder()
      .optionallyWith(
        enableSipMediaApplicationMessageLogs.map(value =>
          value: java.lang.Boolean
        )
      )(_.enableSipMediaApplicationMessageLogs)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration.ReadOnly =
    zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration
      .wrap(buildAwsValue())
}
object SipMediaApplicationLoggingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration =
      zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration(
        enableSipMediaApplicationMessageLogs.map(value => value)
      )
    def enableSipMediaApplicationMessageLogs: Optional[Boolean]
    def getEnableSipMediaApplicationMessageLogs: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableSipMediaApplicationMessageLogs",
        enableSipMediaApplicationMessageLogs
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration
  ) extends zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration.ReadOnly {
    override val enableSipMediaApplicationMessageLogs: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableSipMediaApplicationMessageLogs())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration
  ): zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration.ReadOnly =
    new Wrapper(impl)
}
