package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.AlexaSkillId
import scala.jdk.CollectionConverters._
final case class SipMediaApplicationAlexaSkillConfiguration(
    alexaSkillStatus: zio.aws.chimesdkvoice.model.AlexaSkillStatus,
    alexaSkillIds: Iterable[AlexaSkillId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration = {
    import SipMediaApplicationAlexaSkillConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration
      .builder()
      .alexaSkillStatus(alexaSkillStatus.unwrap)
      .alexaSkillIds(alexaSkillIds.map { item =>
        AlexaSkillId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration.ReadOnly =
    zio.aws.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration
      .wrap(buildAwsValue())
}
object SipMediaApplicationAlexaSkillConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration =
      zio.aws.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration(
        alexaSkillStatus,
        alexaSkillIds
      )
    def alexaSkillStatus: zio.aws.chimesdkvoice.model.AlexaSkillStatus
    def alexaSkillIds: List[AlexaSkillId]
    def getAlexaSkillStatus
        : ZIO[Any, Nothing, zio.aws.chimesdkvoice.model.AlexaSkillStatus] =
      ZIO.succeed(alexaSkillStatus)
    def getAlexaSkillIds: ZIO[Any, Nothing, List[AlexaSkillId]] =
      ZIO.succeed(alexaSkillIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration
  ) extends zio.aws.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration.ReadOnly {
    override val alexaSkillStatus
        : zio.aws.chimesdkvoice.model.AlexaSkillStatus =
      zio.aws.chimesdkvoice.model.AlexaSkillStatus.wrap(impl.alexaSkillStatus())
    override val alexaSkillIds: List[AlexaSkillId] = impl
      .alexaSkillIds()
      .asScala
      .map { item =>
        zio.aws.chimesdkvoice.model.primitives.AlexaSkillId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration
  ): zio.aws.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration.ReadOnly =
    new Wrapper(impl)
}
