package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorTerminationCredentialsRequest(
    voiceConnectorId: NonEmptyString,
    credentials: Optional[Iterable[zio.aws.chimesdkvoice.model.Credential]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationCredentialsRequest = {
    import PutVoiceConnectorTerminationCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationCredentialsRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .optionallyWith(
        credentials.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.credentials)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationCredentialsRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationCredentialsRequest
      .wrap(buildAwsValue())
}
object PutVoiceConnectorTerminationCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationCredentialsRequest =
      zio.aws.chimesdkvoice.model
        .PutVoiceConnectorTerminationCredentialsRequest(
          voiceConnectorId,
          credentials.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def voiceConnectorId: NonEmptyString
    def credentials
        : Optional[List[zio.aws.chimesdkvoice.model.Credential.ReadOnly]]
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getCredentials: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.Credential.ReadOnly
    ]] = AwsError.unwrapOptionField("credentials", credentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationCredentialsRequest
  ) extends zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationCredentialsRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorId())
    override val credentials
        : Optional[List[zio.aws.chimesdkvoice.model.Credential.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkvoice.model.Credential.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationCredentialsRequest
  ): zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
