package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorProxyResponse(
    proxy: Optional[zio.aws.chimesdkvoice.model.Proxy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorProxyResponse = {
    import PutVoiceConnectorProxyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorProxyResponse
      .builder()
      .optionallyWith(proxy.map(value => value.buildAwsValue()))(_.proxy)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyResponse
      .wrap(buildAwsValue())
}
object PutVoiceConnectorProxyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorProxyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyResponse =
      zio.aws.chimesdkvoice.model
        .PutVoiceConnectorProxyResponse(proxy.map(value => value.asEditable))
    def proxy: Optional[zio.aws.chimesdkvoice.model.Proxy.ReadOnly]
    def getProxy
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.Proxy.ReadOnly] =
      AwsError.unwrapOptionField("proxy", proxy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorProxyResponse
  ) extends zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyResponse.ReadOnly {
    override val proxy: Optional[zio.aws.chimesdkvoice.model.Proxy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxy())
        .map(value => zio.aws.chimesdkvoice.model.Proxy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorProxyResponse
  ): zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyResponse.ReadOnly =
    new Wrapper(impl)
}
