package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorOriginationResponse(
    origination: Optional[zio.aws.chimesdkvoice.model.Origination] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorOriginationResponse = {
    import PutVoiceConnectorOriginationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorOriginationResponse
      .builder()
      .optionallyWith(origination.map(value => value.buildAwsValue()))(
        _.origination
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationResponse
      .wrap(buildAwsValue())
}
object PutVoiceConnectorOriginationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorOriginationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationResponse =
      zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationResponse(
        origination.map(value => value.asEditable)
      )
    def origination: Optional[zio.aws.chimesdkvoice.model.Origination.ReadOnly]
    def getOrigination
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.Origination.ReadOnly] =
      AwsError.unwrapOptionField("origination", origination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorOriginationResponse
  ) extends zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationResponse.ReadOnly {
    override val origination
        : Optional[zio.aws.chimesdkvoice.model.Origination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.origination())
        .map(value => zio.aws.chimesdkvoice.model.Origination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorOriginationResponse
  ): zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationResponse.ReadOnly =
    new Wrapper(impl)
}
