package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString
import scala.jdk.CollectionConverters._
final case class PhoneNumberError(
    phoneNumberId: Optional[SensitiveNonEmptyString] = Optional.Absent,
    errorCode: Optional[zio.aws.chimesdkvoice.model.ErrorCode] =
      Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberError = {
    import PhoneNumberError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberError
      .builder()
      .optionallyWith(
        phoneNumberId.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.phoneNumberId)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.PhoneNumberError.ReadOnly =
    zio.aws.chimesdkvoice.model.PhoneNumberError.wrap(buildAwsValue())
}
object PhoneNumberError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.PhoneNumberError =
      zio.aws.chimesdkvoice.model.PhoneNumberError(
        phoneNumberId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def phoneNumberId: Optional[SensitiveNonEmptyString]
    def errorCode: Optional[zio.aws.chimesdkvoice.model.ErrorCode]
    def errorMessage: Optional[String]
    def getPhoneNumberId: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("phoneNumberId", phoneNumberId)
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberError
  ) extends zio.aws.chimesdkvoice.model.PhoneNumberError.ReadOnly {
    override val phoneNumberId: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberId())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
    override val errorCode: Optional[zio.aws.chimesdkvoice.model.ErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.chimesdkvoice.model.ErrorCode.wrap(value))
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberError
  ): zio.aws.chimesdkvoice.model.PhoneNumberError.ReadOnly = new Wrapper(impl)
}
