package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.NullableBoolean
import scala.jdk.CollectionConverters._
final case class PhoneNumberCapabilities(
    inboundCall: Optional[NullableBoolean] = Optional.Absent,
    outboundCall: Optional[NullableBoolean] = Optional.Absent,
    inboundSMS: Optional[NullableBoolean] = Optional.Absent,
    outboundSMS: Optional[NullableBoolean] = Optional.Absent,
    inboundMMS: Optional[NullableBoolean] = Optional.Absent,
    outboundMMS: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberCapabilities = {
    import PhoneNumberCapabilities.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberCapabilities
      .builder()
      .optionallyWith(inboundCall.map(value => value: java.lang.Boolean))(
        _.inboundCall
      )
      .optionallyWith(outboundCall.map(value => value: java.lang.Boolean))(
        _.outboundCall
      )
      .optionallyWith(inboundSMS.map(value => value: java.lang.Boolean))(
        _.inboundSMS
      )
      .optionallyWith(outboundSMS.map(value => value: java.lang.Boolean))(
        _.outboundSMS
      )
      .optionallyWith(inboundMMS.map(value => value: java.lang.Boolean))(
        _.inboundMMS
      )
      .optionallyWith(outboundMMS.map(value => value: java.lang.Boolean))(
        _.outboundMMS
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.PhoneNumberCapabilities.ReadOnly =
    zio.aws.chimesdkvoice.model.PhoneNumberCapabilities.wrap(buildAwsValue())
}
object PhoneNumberCapabilities {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberCapabilities
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.PhoneNumberCapabilities =
      zio.aws.chimesdkvoice.model.PhoneNumberCapabilities(
        inboundCall.map(value => value),
        outboundCall.map(value => value),
        inboundSMS.map(value => value),
        outboundSMS.map(value => value),
        inboundMMS.map(value => value),
        outboundMMS.map(value => value)
      )
    def inboundCall: Optional[NullableBoolean]
    def outboundCall: Optional[NullableBoolean]
    def inboundSMS: Optional[NullableBoolean]
    def outboundSMS: Optional[NullableBoolean]
    def inboundMMS: Optional[NullableBoolean]
    def outboundMMS: Optional[NullableBoolean]
    def getInboundCall: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("inboundCall", inboundCall)
    def getOutboundCall: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("outboundCall", outboundCall)
    def getInboundSMS: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("inboundSMS", inboundSMS)
    def getOutboundSMS: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("outboundSMS", outboundSMS)
    def getInboundMMS: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("inboundMMS", inboundMMS)
    def getOutboundMMS: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("outboundMMS", outboundMMS)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberCapabilities
  ) extends zio.aws.chimesdkvoice.model.PhoneNumberCapabilities.ReadOnly {
    override val inboundCall: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.inboundCall())
      .map(value => value: NullableBoolean)
    override val outboundCall: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.outboundCall())
      .map(value => value: NullableBoolean)
    override val inboundSMS: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.inboundSMS())
      .map(value => value: NullableBoolean)
    override val outboundSMS: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.outboundSMS())
      .map(value => value: NullableBoolean)
    override val inboundMMS: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.inboundMMS())
      .map(value => value: NullableBoolean)
    override val outboundMMS: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.outboundMMS())
      .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberCapabilities
  ): zio.aws.chimesdkvoice.model.PhoneNumberCapabilities.ReadOnly = new Wrapper(
    impl
  )
}
