package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class MediaInsightsConfiguration(
    disabled: Optional[Boolean] = Optional.Absent,
    configurationArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.MediaInsightsConfiguration = {
    import MediaInsightsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.MediaInsightsConfiguration
      .builder()
      .optionallyWith(disabled.map(value => value: java.lang.Boolean))(
        _.disabled
      )
      .optionallyWith(
        configurationArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.configurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.MediaInsightsConfiguration.ReadOnly =
    zio.aws.chimesdkvoice.model.MediaInsightsConfiguration.wrap(buildAwsValue())
}
object MediaInsightsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.MediaInsightsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.MediaInsightsConfiguration =
      zio.aws.chimesdkvoice.model.MediaInsightsConfiguration(
        disabled.map(value => value),
        configurationArn.map(value => value)
      )
    def disabled: Optional[Boolean]
    def configurationArn: Optional[Arn]
    def getDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disabled", disabled)
    def getConfigurationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("configurationArn", configurationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.MediaInsightsConfiguration
  ) extends zio.aws.chimesdkvoice.model.MediaInsightsConfiguration.ReadOnly {
    override val disabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => value: Boolean)
    override val configurationArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationArn())
      .map(value => zio.aws.chimesdkvoice.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.MediaInsightsConfiguration
  ): zio.aws.chimesdkvoice.model.MediaInsightsConfiguration.ReadOnly =
    new Wrapper(impl)
}
