package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVoiceProfilesResponse(
    voiceProfiles: Optional[
      Iterable[zio.aws.chimesdkvoice.model.VoiceProfileSummary]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesResponse = {
    import ListVoiceProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesResponse
      .builder()
      .optionallyWith(
        voiceProfiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.voiceProfiles)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ListVoiceProfilesResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.ListVoiceProfilesResponse.wrap(buildAwsValue())
}
object ListVoiceProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.ListVoiceProfilesResponse =
      zio.aws.chimesdkvoice.model.ListVoiceProfilesResponse(
        voiceProfiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def voiceProfiles: Optional[
      List[zio.aws.chimesdkvoice.model.VoiceProfileSummary.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getVoiceProfiles: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.VoiceProfileSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("voiceProfiles", voiceProfiles)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesResponse
  ) extends zio.aws.chimesdkvoice.model.ListVoiceProfilesResponse.ReadOnly {
    override val voiceProfiles: Optional[
      List[zio.aws.chimesdkvoice.model.VoiceProfileSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.voiceProfiles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.VoiceProfileSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesResponse
  ): zio.aws.chimesdkvoice.model.ListVoiceProfilesResponse.ReadOnly =
    new Wrapper(impl)
}
