package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceARN: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(Arn.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.ListTagsForResourceRequest =
      zio.aws.chimesdkvoice.model.ListTagsForResourceRequest(resourceARN)
    def resourceARN: Arn
    def getResourceARN: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListTagsForResourceRequest
  ) extends zio.aws.chimesdkvoice.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: Arn =
      zio.aws.chimesdkvoice.model.primitives.Arn(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListTagsForResourceRequest
  ): zio.aws.chimesdkvoice.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
