package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.ResultMax
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPhoneNumbersRequest(
    status: Optional[String] = Optional.Absent,
    productType: Optional[zio.aws.chimesdkvoice.model.PhoneNumberProductType] =
      Optional.Absent,
    filterName: Optional[
      zio.aws.chimesdkvoice.model.PhoneNumberAssociationName
    ] = Optional.Absent,
    filterValue: Optional[String] = Optional.Absent,
    maxResults: Optional[ResultMax] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest = {
    import ListPhoneNumbersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(productType.map(value => value.unwrap))(_.productType)
      .optionallyWith(filterName.map(value => value.unwrap))(_.filterName)
      .optionallyWith(filterValue.map(value => value: java.lang.String))(
        _.filterValue
      )
      .optionallyWith(
        maxResults.map(value => ResultMax.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.ListPhoneNumbersRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.ListPhoneNumbersRequest.wrap(buildAwsValue())
}
object ListPhoneNumbersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.ListPhoneNumbersRequest =
      zio.aws.chimesdkvoice.model.ListPhoneNumbersRequest(
        status.map(value => value),
        productType.map(value => value),
        filterName.map(value => value),
        filterValue.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def status: Optional[String]
    def productType
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberProductType]
    def filterName
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberAssociationName]
    def filterValue: Optional[String]
    def maxResults: Optional[ResultMax]
    def nextToken: Optional[String]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getProductType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.PhoneNumberProductType
    ] = AwsError.unwrapOptionField("productType", productType)
    def getFilterName: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.PhoneNumberAssociationName
    ] = AwsError.unwrapOptionField("filterName", filterName)
    def getFilterValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("filterValue", filterValue)
    def getMaxResults: ZIO[Any, AwsError, ResultMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest
  ) extends zio.aws.chimesdkvoice.model.ListPhoneNumbersRequest.ReadOnly {
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val productType
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberProductType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productType())
        .map(value =>
          zio.aws.chimesdkvoice.model.PhoneNumberProductType.wrap(value)
        )
    override val filterName
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberAssociationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterName())
        .map(value =>
          zio.aws.chimesdkvoice.model.PhoneNumberAssociationName.wrap(value)
        )
    override val filterValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.filterValue())
      .map(value => value: String)
    override val maxResults: Optional[ResultMax] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.chimesdkvoice.model.primitives.ResultMax(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest
  ): zio.aws.chimesdkvoice.model.ListPhoneNumbersRequest.ReadOnly = new Wrapper(
    impl
  )
}
