package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceProfileResponse(
    voiceProfile: Optional[zio.aws.chimesdkvoice.model.VoiceProfile] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileResponse = {
    import GetVoiceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileResponse
      .builder()
      .optionallyWith(voiceProfile.map(value => value.buildAwsValue()))(
        _.voiceProfile
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.GetVoiceProfileResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceProfileResponse.wrap(buildAwsValue())
}
object GetVoiceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetVoiceProfileResponse =
      zio.aws.chimesdkvoice.model
        .GetVoiceProfileResponse(voiceProfile.map(value => value.asEditable))
    def voiceProfile
        : Optional[zio.aws.chimesdkvoice.model.VoiceProfile.ReadOnly]
    def getVoiceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("voiceProfile", voiceProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileResponse
  ) extends zio.aws.chimesdkvoice.model.GetVoiceProfileResponse.ReadOnly {
    override val voiceProfile
        : Optional[zio.aws.chimesdkvoice.model.VoiceProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceProfile())
        .map(value => zio.aws.chimesdkvoice.model.VoiceProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileResponse
  ): zio.aws.chimesdkvoice.model.GetVoiceProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
