package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString256
import scala.jdk.CollectionConverters._
final case class GetVoiceProfileDomainRequest(
    voiceProfileDomainId: NonEmptyString256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileDomainRequest = {
    import GetVoiceProfileDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileDomainRequest
      .builder()
      .voiceProfileDomainId(
        NonEmptyString256.unwrap(voiceProfileDomainId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetVoiceProfileDomainRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceProfileDomainRequest
      .wrap(buildAwsValue())
}
object GetVoiceProfileDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetVoiceProfileDomainRequest =
      zio.aws.chimesdkvoice.model
        .GetVoiceProfileDomainRequest(voiceProfileDomainId)
    def voiceProfileDomainId: NonEmptyString256
    def getVoiceProfileDomainId: ZIO[Any, Nothing, NonEmptyString256] =
      ZIO.succeed(voiceProfileDomainId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileDomainRequest
  ) extends zio.aws.chimesdkvoice.model.GetVoiceProfileDomainRequest.ReadOnly {
    override val voiceProfileDomainId: NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString256(impl.voiceProfileDomainId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileDomainRequest
  ): zio.aws.chimesdkvoice.model.GetVoiceProfileDomainRequest.ReadOnly =
    new Wrapper(impl)
}
