package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString128
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorProxyRequest(
    voiceConnectorId: NonEmptyString128
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorProxyRequest = {
    import GetVoiceConnectorProxyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorProxyRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString128.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyRequest
      .wrap(buildAwsValue())
}
object GetVoiceConnectorProxyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorProxyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyRequest =
      zio.aws.chimesdkvoice.model
        .GetVoiceConnectorProxyRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString128
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorProxyRequest
  ) extends zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString128 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString128(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorProxyRequest
  ): zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyRequest.ReadOnly =
    new Wrapper(impl)
}
