package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorEmergencyCallingConfigurationResponse(
    emergencyCallingConfiguration: Optional[
      zio.aws.chimesdkvoice.model.EmergencyCallingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse = {
    import GetVoiceConnectorEmergencyCallingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse
      .builder()
      .optionallyWith(
        emergencyCallingConfiguration.map(value => value.buildAwsValue())
      )(_.emergencyCallingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse
      .wrap(buildAwsValue())
}
object GetVoiceConnectorEmergencyCallingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse =
      zio.aws.chimesdkvoice.model
        .GetVoiceConnectorEmergencyCallingConfigurationResponse(
          emergencyCallingConfiguration.map(value => value.asEditable)
        )
    def emergencyCallingConfiguration: Optional[
      zio.aws.chimesdkvoice.model.EmergencyCallingConfiguration.ReadOnly
    ]
    def getEmergencyCallingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.EmergencyCallingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "emergencyCallingConfiguration",
      emergencyCallingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse
  ) extends zio.aws.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly {
    override val emergencyCallingConfiguration: Optional[
      zio.aws.chimesdkvoice.model.EmergencyCallingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.emergencyCallingConfiguration())
      .map(value =>
        zio.aws.chimesdkvoice.model.EmergencyCallingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse
  ): zio.aws.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
