package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class GetSipMediaApplicationRequest(
    sipMediaApplicationId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationRequest = {
    import GetSipMediaApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationRequest
      .builder()
      .sipMediaApplicationId(
        NonEmptyString.unwrap(sipMediaApplicationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetSipMediaApplicationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.GetSipMediaApplicationRequest
      .wrap(buildAwsValue())
}
object GetSipMediaApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetSipMediaApplicationRequest =
      zio.aws.chimesdkvoice.model
        .GetSipMediaApplicationRequest(sipMediaApplicationId)
    def sipMediaApplicationId: NonEmptyString
    def getSipMediaApplicationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(sipMediaApplicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationRequest
  ) extends zio.aws.chimesdkvoice.model.GetSipMediaApplicationRequest.ReadOnly {
    override val sipMediaApplicationId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.sipMediaApplicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationRequest
  ): zio.aws.chimesdkvoice.model.GetSipMediaApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
