package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString128
import scala.jdk.CollectionConverters._
final case class GetProxySessionRequest(
    voiceConnectorId: NonEmptyString128,
    proxySessionId: NonEmptyString128
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetProxySessionRequest = {
    import GetProxySessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetProxySessionRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString128.unwrap(voiceConnectorId): java.lang.String
      )
      .proxySessionId(
        NonEmptyString128.unwrap(proxySessionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.GetProxySessionRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.GetProxySessionRequest.wrap(buildAwsValue())
}
object GetProxySessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetProxySessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetProxySessionRequest =
      zio.aws.chimesdkvoice.model
        .GetProxySessionRequest(voiceConnectorId, proxySessionId)
    def voiceConnectorId: NonEmptyString128
    def proxySessionId: NonEmptyString128
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(voiceConnectorId)
    def getProxySessionId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(proxySessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetProxySessionRequest
  ) extends zio.aws.chimesdkvoice.model.GetProxySessionRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString128 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString128(impl.voiceConnectorId())
    override val proxySessionId: NonEmptyString128 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString128(impl.proxySessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetProxySessionRequest
  ): zio.aws.chimesdkvoice.model.GetProxySessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
