package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVoiceConnectorGroupResponse(
    voiceConnectorGroup: Optional[
      zio.aws.chimesdkvoice.model.VoiceConnectorGroup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorGroupResponse = {
    import CreateVoiceConnectorGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorGroupResponse
      .builder()
      .optionallyWith(voiceConnectorGroup.map(value => value.buildAwsValue()))(
        _.voiceConnectorGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupResponse
      .wrap(buildAwsValue())
}
object CreateVoiceConnectorGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupResponse =
      zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupResponse(
        voiceConnectorGroup.map(value => value.asEditable)
      )
    def voiceConnectorGroup
        : Optional[zio.aws.chimesdkvoice.model.VoiceConnectorGroup.ReadOnly]
    def getVoiceConnectorGroup: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceConnectorGroup.ReadOnly
    ] = AwsError.unwrapOptionField("voiceConnectorGroup", voiceConnectorGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorGroupResponse
  ) extends zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupResponse.ReadOnly {
    override val voiceConnectorGroup
        : Optional[zio.aws.chimesdkvoice.model.VoiceConnectorGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnectorGroup())
        .map(value =>
          zio.aws.chimesdkvoice.model.VoiceConnectorGroup.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorGroupResponse
  ): zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupResponse.ReadOnly =
    new Wrapper(impl)
}
