package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.VoiceConnectorGroupName
import scala.jdk.CollectionConverters._
final case class CreateVoiceConnectorGroupRequest(
    name: VoiceConnectorGroupName,
    voiceConnectorItems: Optional[
      Iterable[zio.aws.chimesdkvoice.model.VoiceConnectorItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorGroupRequest = {
    import CreateVoiceConnectorGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorGroupRequest
      .builder()
      .name(VoiceConnectorGroupName.unwrap(name): java.lang.String)
      .optionallyWith(
        voiceConnectorItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.voiceConnectorItems)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupRequest
      .wrap(buildAwsValue())
}
object CreateVoiceConnectorGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupRequest =
      zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupRequest(
        name,
        voiceConnectorItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: VoiceConnectorGroupName
    def voiceConnectorItems: Optional[
      List[zio.aws.chimesdkvoice.model.VoiceConnectorItem.ReadOnly]
    ]
    def getName: ZIO[Any, Nothing, VoiceConnectorGroupName] = ZIO.succeed(name)
    def getVoiceConnectorItems: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.VoiceConnectorItem.ReadOnly
    ]] = AwsError.unwrapOptionField("voiceConnectorItems", voiceConnectorItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorGroupRequest
  ) extends zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupRequest.ReadOnly {
    override val name: VoiceConnectorGroupName =
      zio.aws.chimesdkvoice.model.primitives
        .VoiceConnectorGroupName(impl.name())
    override val voiceConnectorItems: Optional[
      List[zio.aws.chimesdkvoice.model.VoiceConnectorItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.voiceConnectorItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.VoiceConnectorItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorGroupRequest
  ): zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupRequest.ReadOnly =
    new Wrapper(impl)
}
