package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.{
  NullableBoolean,
  NonEmptyString,
  SipRuleName
}
import scala.jdk.CollectionConverters._
final case class CreateSipRuleRequest(
    name: SipRuleName,
    triggerType: zio.aws.chimesdkvoice.model.SipRuleTriggerType,
    triggerValue: NonEmptyString,
    disabled: Optional[NullableBoolean] = Optional.Absent,
    targetApplications: Optional[
      Iterable[zio.aws.chimesdkvoice.model.SipRuleTargetApplication]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreateSipRuleRequest = {
    import CreateSipRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreateSipRuleRequest
      .builder()
      .name(SipRuleName.unwrap(name): java.lang.String)
      .triggerType(triggerType.unwrap)
      .triggerValue(NonEmptyString.unwrap(triggerValue): java.lang.String)
      .optionallyWith(disabled.map(value => value: java.lang.Boolean))(
        _.disabled
      )
      .optionallyWith(
        targetApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetApplications)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.CreateSipRuleRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.CreateSipRuleRequest.wrap(buildAwsValue())
}
object CreateSipRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreateSipRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.CreateSipRuleRequest =
      zio.aws.chimesdkvoice.model.CreateSipRuleRequest(
        name,
        triggerType,
        triggerValue,
        disabled.map(value => value),
        targetApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: SipRuleName
    def triggerType: zio.aws.chimesdkvoice.model.SipRuleTriggerType
    def triggerValue: NonEmptyString
    def disabled: Optional[NullableBoolean]
    def targetApplications: Optional[
      List[zio.aws.chimesdkvoice.model.SipRuleTargetApplication.ReadOnly]
    ]
    def getName: ZIO[Any, Nothing, SipRuleName] = ZIO.succeed(name)
    def getTriggerType
        : ZIO[Any, Nothing, zio.aws.chimesdkvoice.model.SipRuleTriggerType] =
      ZIO.succeed(triggerType)
    def getTriggerValue: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(triggerValue)
    def getDisabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("disabled", disabled)
    def getTargetApplications: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.SipRuleTargetApplication.ReadOnly
    ]] = AwsError.unwrapOptionField("targetApplications", targetApplications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateSipRuleRequest
  ) extends zio.aws.chimesdkvoice.model.CreateSipRuleRequest.ReadOnly {
    override val name: SipRuleName =
      zio.aws.chimesdkvoice.model.primitives.SipRuleName(impl.name())
    override val triggerType: zio.aws.chimesdkvoice.model.SipRuleTriggerType =
      zio.aws.chimesdkvoice.model.SipRuleTriggerType.wrap(impl.triggerType())
    override val triggerValue: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives.NonEmptyString(impl.triggerValue())
    override val disabled: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => value: NullableBoolean)
    override val targetApplications: Optional[
      List[zio.aws.chimesdkvoice.model.SipRuleTargetApplication.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.SipRuleTargetApplication.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateSipRuleRequest
  ): zio.aws.chimesdkvoice.model.CreateSipRuleRequest.ReadOnly = new Wrapper(
    impl
  )
}
