package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{
  PositiveInteger,
  ProxySessionNameString,
  E164PhoneNumber,
  NonEmptyString128
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateProxySessionRequest(
    voiceConnectorId: NonEmptyString128,
    participantPhoneNumbers: Iterable[E164PhoneNumber],
    name: Optional[ProxySessionNameString] = Optional.Absent,
    expiryMinutes: Optional[PositiveInteger] = Optional.Absent,
    capabilities: Iterable[zio.aws.chimesdkvoice.model.Capability],
    numberSelectionBehavior: Optional[
      zio.aws.chimesdkvoice.model.NumberSelectionBehavior
    ] = Optional.Absent,
    geoMatchLevel: Optional[zio.aws.chimesdkvoice.model.GeoMatchLevel] =
      Optional.Absent,
    geoMatchParams: Optional[zio.aws.chimesdkvoice.model.GeoMatchParams] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreateProxySessionRequest = {
    import CreateProxySessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreateProxySessionRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString128.unwrap(voiceConnectorId): java.lang.String
      )
      .participantPhoneNumbers(participantPhoneNumbers.map { item =>
        E164PhoneNumber.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        name.map(value =>
          ProxySessionNameString.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        expiryMinutes.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.expiryMinutes)
      .capabilitiesWithStrings(capabilities.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(numberSelectionBehavior.map(value => value.unwrap))(
        _.numberSelectionBehavior
      )
      .optionallyWith(geoMatchLevel.map(value => value.unwrap))(_.geoMatchLevel)
      .optionallyWith(geoMatchParams.map(value => value.buildAwsValue()))(
        _.geoMatchParams
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.CreateProxySessionRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.CreateProxySessionRequest.wrap(buildAwsValue())
}
object CreateProxySessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreateProxySessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.CreateProxySessionRequest =
      zio.aws.chimesdkvoice.model.CreateProxySessionRequest(
        voiceConnectorId,
        participantPhoneNumbers,
        name.map(value => value),
        expiryMinutes.map(value => value),
        capabilities,
        numberSelectionBehavior.map(value => value),
        geoMatchLevel.map(value => value),
        geoMatchParams.map(value => value.asEditable)
      )
    def voiceConnectorId: NonEmptyString128
    def participantPhoneNumbers: List[E164PhoneNumber]
    def name: Optional[ProxySessionNameString]
    def expiryMinutes: Optional[PositiveInteger]
    def capabilities: List[zio.aws.chimesdkvoice.model.Capability]
    def numberSelectionBehavior
        : Optional[zio.aws.chimesdkvoice.model.NumberSelectionBehavior]
    def geoMatchLevel: Optional[zio.aws.chimesdkvoice.model.GeoMatchLevel]
    def geoMatchParams
        : Optional[zio.aws.chimesdkvoice.model.GeoMatchParams.ReadOnly]
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(voiceConnectorId)
    def getParticipantPhoneNumbers: ZIO[Any, Nothing, List[E164PhoneNumber]] =
      ZIO.succeed(participantPhoneNumbers)
    def getName: ZIO[Any, AwsError, ProxySessionNameString] =
      AwsError.unwrapOptionField("name", name)
    def getExpiryMinutes: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("expiryMinutes", expiryMinutes)
    def getCapabilities
        : ZIO[Any, Nothing, List[zio.aws.chimesdkvoice.model.Capability]] =
      ZIO.succeed(capabilities)
    def getNumberSelectionBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.NumberSelectionBehavior
    ] = AwsError.unwrapOptionField(
      "numberSelectionBehavior",
      numberSelectionBehavior
    )
    def getGeoMatchLevel
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.GeoMatchLevel] =
      AwsError.unwrapOptionField("geoMatchLevel", geoMatchLevel)
    def getGeoMatchParams: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.GeoMatchParams.ReadOnly
    ] = AwsError.unwrapOptionField("geoMatchParams", geoMatchParams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateProxySessionRequest
  ) extends zio.aws.chimesdkvoice.model.CreateProxySessionRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString128 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString128(impl.voiceConnectorId())
    override val participantPhoneNumbers: List[E164PhoneNumber] = impl
      .participantPhoneNumbers()
      .asScala
      .map { item =>
        zio.aws.chimesdkvoice.model.primitives.E164PhoneNumber(item)
      }
      .toList
    override val name: Optional[ProxySessionNameString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.chimesdkvoice.model.primitives.ProxySessionNameString(value)
      )
    override val expiryMinutes: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expiryMinutes())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.PositiveInteger(value)
        )
    override val capabilities: List[zio.aws.chimesdkvoice.model.Capability] =
      impl
        .capabilities()
        .asScala
        .map { item =>
          zio.aws.chimesdkvoice.model.Capability.wrap(item)
        }
        .toList
    override val numberSelectionBehavior
        : Optional[zio.aws.chimesdkvoice.model.NumberSelectionBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberSelectionBehavior())
        .map(value =>
          zio.aws.chimesdkvoice.model.NumberSelectionBehavior.wrap(value)
        )
    override val geoMatchLevel
        : Optional[zio.aws.chimesdkvoice.model.GeoMatchLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geoMatchLevel())
        .map(value => zio.aws.chimesdkvoice.model.GeoMatchLevel.wrap(value))
    override val geoMatchParams
        : Optional[zio.aws.chimesdkvoice.model.GeoMatchParams.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geoMatchParams())
        .map(value => zio.aws.chimesdkvoice.model.GeoMatchParams.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateProxySessionRequest
  ): zio.aws.chimesdkvoice.model.CreateProxySessionRequest.ReadOnly =
    new Wrapper(impl)
}
