package zio.aws.chimesdkvoice
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.chimesdkvoice.model.primitives.{
  E164PhoneNumber,
  CallingRegion,
  AlexaSkillId,
  Country,
  SensitiveString,
  TagKey
}
import zio.aws.chimesdkvoice.model.primitives.VoiceConnectorGroupName.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AlexaSkillId extends Subtype[String]
    type AlexaSkillId = zio.aws.chimesdkvoice.model.primitives.AlexaSkillId.Type
    object Alpha2CountryCode extends Subtype[String]
    type Alpha2CountryCode =
      zio.aws.chimesdkvoice.model.primitives.Alpha2CountryCode.Type
    object AreaCode extends Subtype[String]
    type AreaCode = zio.aws.chimesdkvoice.model.primitives.AreaCode.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.chimesdkvoice.model.primitives.Arn.Type
    object CallingName extends Subtype[String]
    type CallingName = zio.aws.chimesdkvoice.model.primitives.CallingName.Type
    object CallingRegion extends Subtype[String]
    type CallingRegion =
      zio.aws.chimesdkvoice.model.primitives.CallingRegion.Type
    object ClientRequestId extends Subtype[String]
    type ClientRequestId =
      zio.aws.chimesdkvoice.model.primitives.ClientRequestId.Type
    object ConfidenceScore extends Subtype[Float]
    type ConfidenceScore =
      zio.aws.chimesdkvoice.model.primitives.ConfidenceScore.Type
    object Country extends Subtype[String]
    type Country = zio.aws.chimesdkvoice.model.primitives.Country.Type
    object CpsLimit extends Subtype[Int]
    type CpsLimit = zio.aws.chimesdkvoice.model.primitives.CpsLimit.Type
    object DataRetentionInHours extends Subtype[Int]
    type DataRetentionInHours =
      zio.aws.chimesdkvoice.model.primitives.DataRetentionInHours.Type
    object E164PhoneNumber extends Subtype[String]
    type E164PhoneNumber =
      zio.aws.chimesdkvoice.model.primitives.E164PhoneNumber.Type
    object FunctionArn extends Subtype[String]
    type FunctionArn = zio.aws.chimesdkvoice.model.primitives.FunctionArn.Type
    object GuidString extends Subtype[String]
    type GuidString = zio.aws.chimesdkvoice.model.primitives.GuidString.Type
    type Integer = Int
    object Iso8601Timestamp extends Subtype[Instant]
    type Iso8601Timestamp =
      zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp.Type
    object NextTokenString extends Subtype[String]
    type NextTokenString =
      zio.aws.chimesdkvoice.model.primitives.NextTokenString.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives.NonEmptyString.Type
    object NonEmptyString128 extends Subtype[String]
    type NonEmptyString128 =
      zio.aws.chimesdkvoice.model.primitives.NonEmptyString128.Type
    object NonEmptyString256 extends Subtype[String]
    type NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives.NonEmptyString256.Type
    type NullableBoolean = Boolean
    object OriginationRoutePriority extends Subtype[Int]
    type OriginationRoutePriority =
      zio.aws.chimesdkvoice.model.primitives.OriginationRoutePriority.Type
    object OriginationRouteWeight extends Subtype[Int]
    type OriginationRouteWeight =
      zio.aws.chimesdkvoice.model.primitives.OriginationRouteWeight.Type
    object PhoneNumberMaxResults extends Subtype[Int]
    type PhoneNumberMaxResults =
      zio.aws.chimesdkvoice.model.primitives.PhoneNumberMaxResults.Type
    object PhoneNumberName extends Subtype[String]
    type PhoneNumberName =
      zio.aws.chimesdkvoice.model.primitives.PhoneNumberName.Type
    object Port extends Subtype[Int]
    type Port = zio.aws.chimesdkvoice.model.primitives.Port.Type
    object PositiveInteger extends Subtype[Int]
    type PositiveInteger =
      zio.aws.chimesdkvoice.model.primitives.PositiveInteger.Type
    object ProxySessionNameString extends Subtype[String]
    type ProxySessionNameString =
      zio.aws.chimesdkvoice.model.primitives.ProxySessionNameString.Type
    object ResultMax extends Subtype[Int]
    type ResultMax = zio.aws.chimesdkvoice.model.primitives.ResultMax.Type
    object SensitiveNonEmptyString extends Subtype[String]
    type SensitiveNonEmptyString =
      zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString.Type
    object SensitiveString extends Subtype[String]
    type SensitiveString =
      zio.aws.chimesdkvoice.model.primitives.SensitiveString.Type
    object SipApplicationPriority extends Subtype[Int]
    type SipApplicationPriority =
      zio.aws.chimesdkvoice.model.primitives.SipApplicationPriority.Type
    object SipMediaApplicationName extends Subtype[String]
    type SipMediaApplicationName =
      zio.aws.chimesdkvoice.model.primitives.SipMediaApplicationName.Type
    object SipRuleName extends Subtype[String]
    type SipRuleName = zio.aws.chimesdkvoice.model.primitives.SipRuleName.Type
    object String128 extends Subtype[String]
    type String128 = zio.aws.chimesdkvoice.model.primitives.String128.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.chimesdkvoice.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.chimesdkvoice.model.primitives.TagValue.Type
    object TollFreePrefix extends Subtype[String]
    type TollFreePrefix =
      zio.aws.chimesdkvoice.model.primitives.TollFreePrefix.Type
    object ValidationResult extends Subtype[Int]
    type ValidationResult =
      zio.aws.chimesdkvoice.model.primitives.ValidationResult.Type
    object VoiceConnectorGroupName extends Subtype[String]
    type VoiceConnectorGroupName =
      zio.aws.chimesdkvoice.model.primitives.VoiceConnectorGroupName.Type
    object VoiceConnectorItemPriority extends Subtype[Int]
    type VoiceConnectorItemPriority =
      zio.aws.chimesdkvoice.model.primitives.VoiceConnectorItemPriority.Type
    object VoiceConnectorName extends Subtype[String]
    type VoiceConnectorName =
      zio.aws.chimesdkvoice.model.primitives.VoiceConnectorName.Type
    object VoiceProfileDomainDescription extends Subtype[String]
    type VoiceProfileDomainDescription =
      zio.aws.chimesdkvoice.model.primitives.VoiceProfileDomainDescription.Type
    object VoiceProfileDomainName extends Subtype[String]
    type VoiceProfileDomainName =
      zio.aws.chimesdkvoice.model.primitives.VoiceProfileDomainName.Type
  }
  type AlexaSkillIdList = List[AlexaSkillId]
  type CallingRegionList = List[CallingRegion]
  type CandidateAddressList = List[zio.aws.chimesdkvoice.model.CandidateAddress]
  type CapabilityList = List[zio.aws.chimesdkvoice.model.Capability]
  type CountryList = List[Country]
  type CredentialList = List[zio.aws.chimesdkvoice.model.Credential]
  type DNISEmergencyCallingConfigurationList =
    List[zio.aws.chimesdkvoice.model.DNISEmergencyCallingConfiguration]
  type E164PhoneNumberList = List[E164PhoneNumber]
  type NonEmptyStringList = List[String]
  type OrderedPhoneNumberList =
    List[zio.aws.chimesdkvoice.model.OrderedPhoneNumber]
  type OriginationRouteList = List[zio.aws.chimesdkvoice.model.OriginationRoute]
  type ParticipantPhoneNumberList = List[E164PhoneNumber]
  type Participants = List[zio.aws.chimesdkvoice.model.Participant]
  type PhoneNumberAssociationList =
    List[zio.aws.chimesdkvoice.model.PhoneNumberAssociation]
  type PhoneNumberCountriesList =
    List[zio.aws.chimesdkvoice.model.PhoneNumberCountry]
  type PhoneNumberErrorList = List[zio.aws.chimesdkvoice.model.PhoneNumberError]
  type PhoneNumberList = List[zio.aws.chimesdkvoice.model.PhoneNumber]
  type PhoneNumberOrderList = List[zio.aws.chimesdkvoice.model.PhoneNumberOrder]
  type PhoneNumberTypeList = List[zio.aws.chimesdkvoice.model.PhoneNumberType]
  type ProxySessions = List[zio.aws.chimesdkvoice.model.ProxySession]
  type SMACreateCallArgumentsMap = Map[SensitiveString, SensitiveString]
  type SMAUpdateCallArgumentsMap = Map[SensitiveString, SensitiveString]
  type SensitiveStringList = List[SensitiveString]
  type SipHeadersMap = Map[SensitiveString, SensitiveString]
  type SipMediaApplicationEndpointList =
    List[zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint]
  type SipMediaApplicationList =
    List[zio.aws.chimesdkvoice.model.SipMediaApplication]
  type SipRuleList = List[zio.aws.chimesdkvoice.model.SipRule]
  type SipRuleTargetApplicationList =
    List[zio.aws.chimesdkvoice.model.SipRuleTargetApplication]
  type SpeakerSearchResultList =
    List[zio.aws.chimesdkvoice.model.SpeakerSearchResult]
  type StreamingNotificationTargetList =
    List[zio.aws.chimesdkvoice.model.StreamingNotificationTarget]
  type StringList = List[String]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.chimesdkvoice.model.Tag]
  type UpdatePhoneNumberRequestItemList =
    List[zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequestItem]
  type VoiceConnectorAwsRegionList =
    List[zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion]
  type VoiceConnectorGroupList =
    List[zio.aws.chimesdkvoice.model.VoiceConnectorGroup]
  type VoiceConnectorItemList =
    List[zio.aws.chimesdkvoice.model.VoiceConnectorItem]
  type VoiceConnectorList = List[zio.aws.chimesdkvoice.model.VoiceConnector]
  type VoiceProfileDomainSummaryList =
    List[zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary]
  type VoiceProfileSummaryList =
    List[zio.aws.chimesdkvoice.model.VoiceProfileSummary]
}
