package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{
  Iso8601Timestamp,
  Arn,
  NonEmptyString256
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class VoiceProfile(
    voiceProfileId: Optional[NonEmptyString256] = Optional.Absent,
    voiceProfileArn: Optional[Arn] = Optional.Absent,
    voiceProfileDomainId: Optional[NonEmptyString256] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    expirationTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfile = {
    import VoiceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfile
      .builder()
      .optionallyWith(
        voiceProfileId.map(value =>
          NonEmptyString256.unwrap(value): java.lang.String
        )
      )(_.voiceProfileId)
      .optionallyWith(
        voiceProfileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.voiceProfileArn)
      .optionallyWith(
        voiceProfileDomainId.map(value =>
          NonEmptyString256.unwrap(value): java.lang.String
        )
      )(_.voiceProfileDomainId)
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .optionallyWith(
        expirationTimestamp.map(value =>
          Iso8601Timestamp.unwrap(value): Instant
        )
      )(_.expirationTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.VoiceProfile.ReadOnly =
    zio.aws.chimesdkvoice.model.VoiceProfile.wrap(buildAwsValue())
}
object VoiceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.VoiceProfile =
      zio.aws.chimesdkvoice.model.VoiceProfile(
        voiceProfileId.map(value => value),
        voiceProfileArn.map(value => value),
        voiceProfileDomainId.map(value => value),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value),
        expirationTimestamp.map(value => value)
      )
    def voiceProfileId: Optional[NonEmptyString256]
    def voiceProfileArn: Optional[Arn]
    def voiceProfileDomainId: Optional[NonEmptyString256]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def expirationTimestamp: Optional[Iso8601Timestamp]
    def getVoiceProfileId: ZIO[Any, AwsError, NonEmptyString256] =
      AwsError.unwrapOptionField("voiceProfileId", voiceProfileId)
    def getVoiceProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("voiceProfileArn", voiceProfileArn)
    def getVoiceProfileDomainId: ZIO[Any, AwsError, NonEmptyString256] =
      AwsError.unwrapOptionField("voiceProfileDomainId", voiceProfileDomainId)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
    def getExpirationTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("expirationTimestamp", expirationTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfile
  ) extends zio.aws.chimesdkvoice.model.VoiceProfile.ReadOnly {
    override val voiceProfileId: Optional[NonEmptyString256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceProfileId())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString256(value)
        )
    override val voiceProfileArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.voiceProfileArn())
      .map(value => zio.aws.chimesdkvoice.model.primitives.Arn(value))
    override val voiceProfileDomainId: Optional[NonEmptyString256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceProfileDomainId())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString256(value)
        )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val expirationTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expirationTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfile
  ): zio.aws.chimesdkvoice.model.VoiceProfile.ReadOnly = new Wrapper(impl)
}
