package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{
  Iso8601Timestamp,
  VoiceConnectorName,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class VoiceConnector(
    voiceConnectorId: Optional[NonEmptyString] = Optional.Absent,
    awsRegion: Optional[zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion] =
      Optional.Absent,
    name: Optional[VoiceConnectorName] = Optional.Absent,
    outboundHostName: Optional[String] = Optional.Absent,
    requireEncryption: Optional[Boolean] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    voiceConnectorArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnector = {
    import VoiceConnector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnector
      .builder()
      .optionallyWith(
        voiceConnectorId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.voiceConnectorId)
      .optionallyWith(awsRegion.map(value => value.unwrap))(_.awsRegion)
      .optionallyWith(
        name.map(value => VoiceConnectorName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(outboundHostName.map(value => value: java.lang.String))(
        _.outboundHostName
      )
      .optionallyWith(requireEncryption.map(value => value: java.lang.Boolean))(
        _.requireEncryption
      )
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .optionallyWith(
        voiceConnectorArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.voiceConnectorArn)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly =
    zio.aws.chimesdkvoice.model.VoiceConnector.wrap(buildAwsValue())
}
object VoiceConnector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.VoiceConnector =
      zio.aws.chimesdkvoice.model.VoiceConnector(
        voiceConnectorId.map(value => value),
        awsRegion.map(value => value),
        name.map(value => value),
        outboundHostName.map(value => value),
        requireEncryption.map(value => value),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value),
        voiceConnectorArn.map(value => value)
      )
    def voiceConnectorId: Optional[NonEmptyString]
    def awsRegion: Optional[zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion]
    def name: Optional[VoiceConnectorName]
    def outboundHostName: Optional[String]
    def requireEncryption: Optional[Boolean]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def voiceConnectorArn: Optional[NonEmptyString]
    def getVoiceConnectorId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("voiceConnectorId", voiceConnectorId)
    def getAwsRegion: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion
    ] = AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getName: ZIO[Any, AwsError, VoiceConnectorName] =
      AwsError.unwrapOptionField("name", name)
    def getOutboundHostName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outboundHostName", outboundHostName)
    def getRequireEncryption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requireEncryption", requireEncryption)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
    def getVoiceConnectorArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("voiceConnectorArn", voiceConnectorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnector
  ) extends zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly {
    override val voiceConnectorId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnectorId())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString(value)
        )
    override val awsRegion
        : Optional[zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsRegion())
        .map(value =>
          zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion.wrap(value)
        )
    override val name: Optional[VoiceConnectorName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.chimesdkvoice.model.primitives.VoiceConnectorName(value)
      )
    override val outboundHostName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outboundHostName())
      .map(value => value: String)
    override val requireEncryption: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.requireEncryption())
      .map(value => value: Boolean)
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val voiceConnectorArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnectorArn())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnector
  ): zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly = new Wrapper(impl)
}
