package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.{
  SensitiveNonEmptyString,
  NonEmptyString
}
import scala.jdk.CollectionConverters._
final case class ValidateE911AddressRequest(
    awsAccountId: NonEmptyString,
    streetNumber: SensitiveNonEmptyString,
    streetInfo: SensitiveNonEmptyString,
    city: SensitiveNonEmptyString,
    state: SensitiveNonEmptyString,
    country: SensitiveNonEmptyString,
    postalCode: SensitiveNonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ValidateE911AddressRequest = {
    import ValidateE911AddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ValidateE911AddressRequest
      .builder()
      .awsAccountId(NonEmptyString.unwrap(awsAccountId): java.lang.String)
      .streetNumber(
        SensitiveNonEmptyString.unwrap(streetNumber): java.lang.String
      )
      .streetInfo(SensitiveNonEmptyString.unwrap(streetInfo): java.lang.String)
      .city(SensitiveNonEmptyString.unwrap(city): java.lang.String)
      .state(SensitiveNonEmptyString.unwrap(state): java.lang.String)
      .country(SensitiveNonEmptyString.unwrap(country): java.lang.String)
      .postalCode(SensitiveNonEmptyString.unwrap(postalCode): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ValidateE911AddressRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.ValidateE911AddressRequest.wrap(buildAwsValue())
}
object ValidateE911AddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ValidateE911AddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.ValidateE911AddressRequest =
      zio.aws.chimesdkvoice.model.ValidateE911AddressRequest(
        awsAccountId,
        streetNumber,
        streetInfo,
        city,
        state,
        country,
        postalCode
      )
    def awsAccountId: NonEmptyString
    def streetNumber: SensitiveNonEmptyString
    def streetInfo: SensitiveNonEmptyString
    def city: SensitiveNonEmptyString
    def state: SensitiveNonEmptyString
    def country: SensitiveNonEmptyString
    def postalCode: SensitiveNonEmptyString
    def getAwsAccountId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(awsAccountId)
    def getStreetNumber: ZIO[Any, Nothing, SensitiveNonEmptyString] =
      ZIO.succeed(streetNumber)
    def getStreetInfo: ZIO[Any, Nothing, SensitiveNonEmptyString] =
      ZIO.succeed(streetInfo)
    def getCity: ZIO[Any, Nothing, SensitiveNonEmptyString] = ZIO.succeed(city)
    def getState: ZIO[Any, Nothing, SensitiveNonEmptyString] =
      ZIO.succeed(state)
    def getCountry: ZIO[Any, Nothing, SensitiveNonEmptyString] =
      ZIO.succeed(country)
    def getPostalCode: ZIO[Any, Nothing, SensitiveNonEmptyString] =
      ZIO.succeed(postalCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ValidateE911AddressRequest
  ) extends zio.aws.chimesdkvoice.model.ValidateE911AddressRequest.ReadOnly {
    override val awsAccountId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives.NonEmptyString(impl.awsAccountId())
    override val streetNumber: SensitiveNonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .SensitiveNonEmptyString(impl.streetNumber())
    override val streetInfo: SensitiveNonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .SensitiveNonEmptyString(impl.streetInfo())
    override val city: SensitiveNonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .SensitiveNonEmptyString(impl.city())
    override val state: SensitiveNonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .SensitiveNonEmptyString(impl.state())
    override val country: SensitiveNonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .SensitiveNonEmptyString(impl.country())
    override val postalCode: SensitiveNonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .SensitiveNonEmptyString(impl.postalCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ValidateE911AddressRequest
  ): zio.aws.chimesdkvoice.model.ValidateE911AddressRequest.ReadOnly =
    new Wrapper(impl)
}
