package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateProxySessionResponse(
    proxySession: Optional[zio.aws.chimesdkvoice.model.ProxySession] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.UpdateProxySessionResponse = {
    import UpdateProxySessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateProxySessionResponse
      .builder()
      .optionallyWith(proxySession.map(value => value.buildAwsValue()))(
        _.proxySession
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.UpdateProxySessionResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.UpdateProxySessionResponse.wrap(buildAwsValue())
}
object UpdateProxySessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateProxySessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.UpdateProxySessionResponse =
      zio.aws.chimesdkvoice.model
        .UpdateProxySessionResponse(proxySession.map(value => value.asEditable))
    def proxySession
        : Optional[zio.aws.chimesdkvoice.model.ProxySession.ReadOnly]
    def getProxySession: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.ProxySession.ReadOnly
    ] = AwsError.unwrapOptionField("proxySession", proxySession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateProxySessionResponse
  ) extends zio.aws.chimesdkvoice.model.UpdateProxySessionResponse.ReadOnly {
    override val proxySession
        : Optional[zio.aws.chimesdkvoice.model.ProxySession.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxySession())
        .map(value => zio.aws.chimesdkvoice.model.ProxySession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateProxySessionResponse
  ): zio.aws.chimesdkvoice.model.UpdateProxySessionResponse.ReadOnly =
    new Wrapper(impl)
}
