package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.{
  PhoneNumberName,
  CallingName,
  SensitiveNonEmptyString
}
import scala.jdk.CollectionConverters._
final case class UpdatePhoneNumberRequestItem(
    phoneNumberId: SensitiveNonEmptyString,
    productType: Optional[zio.aws.chimesdkvoice.model.PhoneNumberProductType] =
      Optional.Absent,
    callingName: Optional[CallingName] = Optional.Absent,
    name: Optional[PhoneNumberName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequestItem = {
    import UpdatePhoneNumberRequestItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequestItem
      .builder()
      .phoneNumberId(
        SensitiveNonEmptyString.unwrap(phoneNumberId): java.lang.String
      )
      .optionallyWith(productType.map(value => value.unwrap))(_.productType)
      .optionallyWith(
        callingName.map(value => CallingName.unwrap(value): java.lang.String)
      )(_.callingName)
      .optionallyWith(
        name.map(value => PhoneNumberName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequestItem.ReadOnly =
    zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequestItem
      .wrap(buildAwsValue())
}
object UpdatePhoneNumberRequestItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequestItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequestItem =
      zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequestItem(
        phoneNumberId,
        productType.map(value => value),
        callingName.map(value => value),
        name.map(value => value)
      )
    def phoneNumberId: SensitiveNonEmptyString
    def productType
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberProductType]
    def callingName: Optional[CallingName]
    def name: Optional[PhoneNumberName]
    def getPhoneNumberId: ZIO[Any, Nothing, SensitiveNonEmptyString] =
      ZIO.succeed(phoneNumberId)
    def getProductType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.PhoneNumberProductType
    ] = AwsError.unwrapOptionField("productType", productType)
    def getCallingName: ZIO[Any, AwsError, CallingName] =
      AwsError.unwrapOptionField("callingName", callingName)
    def getName: ZIO[Any, AwsError, PhoneNumberName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequestItem
  ) extends zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequestItem.ReadOnly {
    override val phoneNumberId: SensitiveNonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .SensitiveNonEmptyString(impl.phoneNumberId())
    override val productType
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberProductType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productType())
        .map(value =>
          zio.aws.chimesdkvoice.model.PhoneNumberProductType.wrap(value)
        )
    override val callingName: Optional[CallingName] = zio.aws.core.internal
      .optionalFromNullable(impl.callingName())
      .map(value => zio.aws.chimesdkvoice.model.primitives.CallingName(value))
    override val name: Optional[PhoneNumberName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.chimesdkvoice.model.primitives.PhoneNumberName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequestItem
  ): zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequestItem.ReadOnly =
    new Wrapper(impl)
}
