package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.{
  NonEmptyString256,
  NonEmptyString128
}
import scala.jdk.CollectionConverters._
final case class StopVoiceToneAnalysisTaskRequest(
    voiceConnectorId: NonEmptyString128,
    voiceToneAnalysisTaskId: NonEmptyString256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.StopVoiceToneAnalysisTaskRequest = {
    import StopVoiceToneAnalysisTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.StopVoiceToneAnalysisTaskRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString128.unwrap(voiceConnectorId): java.lang.String
      )
      .voiceToneAnalysisTaskId(
        NonEmptyString256.unwrap(voiceToneAnalysisTaskId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.StopVoiceToneAnalysisTaskRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.StopVoiceToneAnalysisTaskRequest
      .wrap(buildAwsValue())
}
object StopVoiceToneAnalysisTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.StopVoiceToneAnalysisTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.StopVoiceToneAnalysisTaskRequest =
      zio.aws.chimesdkvoice.model.StopVoiceToneAnalysisTaskRequest(
        voiceConnectorId,
        voiceToneAnalysisTaskId
      )
    def voiceConnectorId: NonEmptyString128
    def voiceToneAnalysisTaskId: NonEmptyString256
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(voiceConnectorId)
    def getVoiceToneAnalysisTaskId: ZIO[Any, Nothing, NonEmptyString256] =
      ZIO.succeed(voiceToneAnalysisTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.StopVoiceToneAnalysisTaskRequest
  ) extends zio.aws.chimesdkvoice.model.StopVoiceToneAnalysisTaskRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString128 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString128(impl.voiceConnectorId())
    override val voiceToneAnalysisTaskId: NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString256(impl.voiceToneAnalysisTaskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.StopVoiceToneAnalysisTaskRequest
  ): zio.aws.chimesdkvoice.model.StopVoiceToneAnalysisTaskRequest.ReadOnly =
    new Wrapper(impl)
}
