package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{
  SipApplicationPriority,
  NonEmptyString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SipRuleTargetApplication(
    sipMediaApplicationId: Optional[NonEmptyString] = Optional.Absent,
    priority: Optional[SipApplicationPriority] = Optional.Absent,
    awsRegion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.SipRuleTargetApplication = {
    import SipRuleTargetApplication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.SipRuleTargetApplication
      .builder()
      .optionallyWith(
        sipMediaApplicationId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sipMediaApplicationId)
      .optionallyWith(
        priority.map(value => SipApplicationPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(awsRegion.map(value => value: java.lang.String))(
        _.awsRegion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.SipRuleTargetApplication.ReadOnly =
    zio.aws.chimesdkvoice.model.SipRuleTargetApplication.wrap(buildAwsValue())
}
object SipRuleTargetApplication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.SipRuleTargetApplication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.SipRuleTargetApplication =
      zio.aws.chimesdkvoice.model.SipRuleTargetApplication(
        sipMediaApplicationId.map(value => value),
        priority.map(value => value),
        awsRegion.map(value => value)
      )
    def sipMediaApplicationId: Optional[NonEmptyString]
    def priority: Optional[SipApplicationPriority]
    def awsRegion: Optional[String]
    def getSipMediaApplicationId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sipMediaApplicationId", sipMediaApplicationId)
    def getPriority: ZIO[Any, AwsError, SipApplicationPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getAwsRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SipRuleTargetApplication
  ) extends zio.aws.chimesdkvoice.model.SipRuleTargetApplication.ReadOnly {
    override val sipMediaApplicationId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipMediaApplicationId())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString(value)
        )
    override val priority: Optional[SipApplicationPriority] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priority())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SipApplicationPriority(value)
        )
    override val awsRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SipRuleTargetApplication
  ): zio.aws.chimesdkvoice.model.SipRuleTargetApplication.ReadOnly =
    new Wrapper(impl)
}
