package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{
  Iso8601Timestamp,
  SipRuleName,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SipRule(
    sipRuleId: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[SipRuleName] = Optional.Absent,
    disabled: Optional[Boolean] = Optional.Absent,
    triggerType: Optional[zio.aws.chimesdkvoice.model.SipRuleTriggerType] =
      Optional.Absent,
    triggerValue: Optional[NonEmptyString] = Optional.Absent,
    targetApplications: Optional[
      Iterable[zio.aws.chimesdkvoice.model.SipRuleTargetApplication]
    ] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.SipRule = {
    import SipRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.SipRule
      .builder()
      .optionallyWith(
        sipRuleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sipRuleId)
      .optionallyWith(
        name.map(value => SipRuleName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(disabled.map(value => value: java.lang.Boolean))(
        _.disabled
      )
      .optionallyWith(triggerType.map(value => value.unwrap))(_.triggerType)
      .optionallyWith(
        triggerValue.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.triggerValue)
      .optionallyWith(
        targetApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetApplications)
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.SipRule.ReadOnly =
    zio.aws.chimesdkvoice.model.SipRule.wrap(buildAwsValue())
}
object SipRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.SipRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.SipRule =
      zio.aws.chimesdkvoice.model.SipRule(
        sipRuleId.map(value => value),
        name.map(value => value),
        disabled.map(value => value),
        triggerType.map(value => value),
        triggerValue.map(value => value),
        targetApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value)
      )
    def sipRuleId: Optional[NonEmptyString]
    def name: Optional[SipRuleName]
    def disabled: Optional[Boolean]
    def triggerType: Optional[zio.aws.chimesdkvoice.model.SipRuleTriggerType]
    def triggerValue: Optional[NonEmptyString]
    def targetApplications: Optional[
      List[zio.aws.chimesdkvoice.model.SipRuleTargetApplication.ReadOnly]
    ]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def getSipRuleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sipRuleId", sipRuleId)
    def getName: ZIO[Any, AwsError, SipRuleName] =
      AwsError.unwrapOptionField("name", name)
    def getDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disabled", disabled)
    def getTriggerType
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.SipRuleTriggerType] =
      AwsError.unwrapOptionField("triggerType", triggerType)
    def getTriggerValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("triggerValue", triggerValue)
    def getTargetApplications: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.SipRuleTargetApplication.ReadOnly
    ]] = AwsError.unwrapOptionField("targetApplications", targetApplications)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SipRule
  ) extends zio.aws.chimesdkvoice.model.SipRule.ReadOnly {
    override val sipRuleId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sipRuleId())
      .map(value =>
        zio.aws.chimesdkvoice.model.primitives.NonEmptyString(value)
      )
    override val name: Optional[SipRuleName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.chimesdkvoice.model.primitives.SipRuleName(value))
    override val disabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => value: Boolean)
    override val triggerType
        : Optional[zio.aws.chimesdkvoice.model.SipRuleTriggerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.triggerType())
        .map(value =>
          zio.aws.chimesdkvoice.model.SipRuleTriggerType.wrap(value)
        )
    override val triggerValue: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.triggerValue())
      .map(value =>
        zio.aws.chimesdkvoice.model.primitives.NonEmptyString(value)
      )
    override val targetApplications: Optional[
      List[zio.aws.chimesdkvoice.model.SipRuleTargetApplication.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.SipRuleTargetApplication.wrap(item)
        }.toList
      )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SipRule
  ): zio.aws.chimesdkvoice.model.SipRule.ReadOnly = new Wrapper(impl)
}
