package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{
  Iso8601Timestamp,
  PositiveInteger,
  String128,
  NonEmptyString128
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ProxySession(
    voiceConnectorId: Optional[NonEmptyString128] = Optional.Absent,
    proxySessionId: Optional[NonEmptyString128] = Optional.Absent,
    name: Optional[String128] = Optional.Absent,
    status: Optional[zio.aws.chimesdkvoice.model.ProxySessionStatus] =
      Optional.Absent,
    expiryMinutes: Optional[PositiveInteger] = Optional.Absent,
    capabilities: Optional[Iterable[zio.aws.chimesdkvoice.model.Capability]] =
      Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    endedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    participants: Optional[Iterable[zio.aws.chimesdkvoice.model.Participant]] =
      Optional.Absent,
    numberSelectionBehavior: Optional[
      zio.aws.chimesdkvoice.model.NumberSelectionBehavior
    ] = Optional.Absent,
    geoMatchLevel: Optional[zio.aws.chimesdkvoice.model.GeoMatchLevel] =
      Optional.Absent,
    geoMatchParams: Optional[zio.aws.chimesdkvoice.model.GeoMatchParams] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ProxySession = {
    import ProxySession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ProxySession
      .builder()
      .optionallyWith(
        voiceConnectorId.map(value =>
          NonEmptyString128.unwrap(value): java.lang.String
        )
      )(_.voiceConnectorId)
      .optionallyWith(
        proxySessionId.map(value =>
          NonEmptyString128.unwrap(value): java.lang.String
        )
      )(_.proxySessionId)
      .optionallyWith(
        name.map(value => String128.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        expiryMinutes.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.expiryMinutes)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .optionallyWith(
        endedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.endedTimestamp)
      .optionallyWith(
        participants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.participants)
      .optionallyWith(numberSelectionBehavior.map(value => value.unwrap))(
        _.numberSelectionBehavior
      )
      .optionallyWith(geoMatchLevel.map(value => value.unwrap))(_.geoMatchLevel)
      .optionallyWith(geoMatchParams.map(value => value.buildAwsValue()))(
        _.geoMatchParams
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.ProxySession.ReadOnly =
    zio.aws.chimesdkvoice.model.ProxySession.wrap(buildAwsValue())
}
object ProxySession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ProxySession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.ProxySession =
      zio.aws.chimesdkvoice.model.ProxySession(
        voiceConnectorId.map(value => value),
        proxySessionId.map(value => value),
        name.map(value => value),
        status.map(value => value),
        expiryMinutes.map(value => value),
        capabilities.map(value => value),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value),
        endedTimestamp.map(value => value),
        participants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        numberSelectionBehavior.map(value => value),
        geoMatchLevel.map(value => value),
        geoMatchParams.map(value => value.asEditable)
      )
    def voiceConnectorId: Optional[NonEmptyString128]
    def proxySessionId: Optional[NonEmptyString128]
    def name: Optional[String128]
    def status: Optional[zio.aws.chimesdkvoice.model.ProxySessionStatus]
    def expiryMinutes: Optional[PositiveInteger]
    def capabilities: Optional[List[zio.aws.chimesdkvoice.model.Capability]]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def endedTimestamp: Optional[Iso8601Timestamp]
    def participants
        : Optional[List[zio.aws.chimesdkvoice.model.Participant.ReadOnly]]
    def numberSelectionBehavior
        : Optional[zio.aws.chimesdkvoice.model.NumberSelectionBehavior]
    def geoMatchLevel: Optional[zio.aws.chimesdkvoice.model.GeoMatchLevel]
    def geoMatchParams
        : Optional[zio.aws.chimesdkvoice.model.GeoMatchParams.ReadOnly]
    def getVoiceConnectorId: ZIO[Any, AwsError, NonEmptyString128] =
      AwsError.unwrapOptionField("voiceConnectorId", voiceConnectorId)
    def getProxySessionId: ZIO[Any, AwsError, NonEmptyString128] =
      AwsError.unwrapOptionField("proxySessionId", proxySessionId)
    def getName: ZIO[Any, AwsError, String128] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.ProxySessionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getExpiryMinutes: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("expiryMinutes", expiryMinutes)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.chimesdkvoice.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
    def getEndedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("endedTimestamp", endedTimestamp)
    def getParticipants: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.Participant.ReadOnly
    ]] = AwsError.unwrapOptionField("participants", participants)
    def getNumberSelectionBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.NumberSelectionBehavior
    ] = AwsError.unwrapOptionField(
      "numberSelectionBehavior",
      numberSelectionBehavior
    )
    def getGeoMatchLevel
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.GeoMatchLevel] =
      AwsError.unwrapOptionField("geoMatchLevel", geoMatchLevel)
    def getGeoMatchParams: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.GeoMatchParams.ReadOnly
    ] = AwsError.unwrapOptionField("geoMatchParams", geoMatchParams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ProxySession
  ) extends zio.aws.chimesdkvoice.model.ProxySession.ReadOnly {
    override val voiceConnectorId: Optional[NonEmptyString128] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnectorId())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString128(value)
        )
    override val proxySessionId: Optional[NonEmptyString128] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxySessionId())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString128(value)
        )
    override val name: Optional[String128] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.chimesdkvoice.model.primitives.String128(value))
    override val status
        : Optional[zio.aws.chimesdkvoice.model.ProxySessionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.chimesdkvoice.model.ProxySessionStatus.wrap(value)
        )
    override val expiryMinutes: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expiryMinutes())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.PositiveInteger(value)
        )
    override val capabilities
        : Optional[List[zio.aws.chimesdkvoice.model.Capability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkvoice.model.Capability.wrap(item)
          }.toList
        )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val endedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endedTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val participants
        : Optional[List[zio.aws.chimesdkvoice.model.Participant.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participants())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkvoice.model.Participant.wrap(item)
          }.toList
        )
    override val numberSelectionBehavior
        : Optional[zio.aws.chimesdkvoice.model.NumberSelectionBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberSelectionBehavior())
        .map(value =>
          zio.aws.chimesdkvoice.model.NumberSelectionBehavior.wrap(value)
        )
    override val geoMatchLevel
        : Optional[zio.aws.chimesdkvoice.model.GeoMatchLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geoMatchLevel())
        .map(value => zio.aws.chimesdkvoice.model.GeoMatchLevel.wrap(value))
    override val geoMatchParams
        : Optional[zio.aws.chimesdkvoice.model.GeoMatchParams.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geoMatchParams())
        .map(value => zio.aws.chimesdkvoice.model.GeoMatchParams.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ProxySession
  ): zio.aws.chimesdkvoice.model.ProxySession.ReadOnly = new Wrapper(impl)
}
