package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVoiceProfileDomainsResponse(
    voiceProfileDomains: Optional[
      Iterable[zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsResponse = {
    import ListVoiceProfileDomainsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsResponse
      .builder()
      .optionallyWith(
        voiceProfileDomains.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.voiceProfileDomains)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ListVoiceProfileDomainsResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.ListVoiceProfileDomainsResponse
      .wrap(buildAwsValue())
}
object ListVoiceProfileDomainsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.ListVoiceProfileDomainsResponse =
      zio.aws.chimesdkvoice.model.ListVoiceProfileDomainsResponse(
        voiceProfileDomains.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def voiceProfileDomains: Optional[
      List[zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getVoiceProfileDomains: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("voiceProfileDomains", voiceProfileDomains)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsResponse
  ) extends zio.aws.chimesdkvoice.model.ListVoiceProfileDomainsResponse.ReadOnly {
    override val voiceProfileDomains: Optional[
      List[zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.voiceProfileDomains())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsResponse
  ): zio.aws.chimesdkvoice.model.ListVoiceProfileDomainsResponse.ReadOnly =
    new Wrapper(impl)
}
