package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPhoneNumberOrdersResponse(
    phoneNumberOrders: Optional[
      Iterable[zio.aws.chimesdkvoice.model.PhoneNumberOrder]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersResponse = {
    import ListPhoneNumberOrdersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersResponse
      .builder()
      .optionallyWith(
        phoneNumberOrders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumberOrders)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ListPhoneNumberOrdersResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.ListPhoneNumberOrdersResponse
      .wrap(buildAwsValue())
}
object ListPhoneNumberOrdersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.ListPhoneNumberOrdersResponse =
      zio.aws.chimesdkvoice.model.ListPhoneNumberOrdersResponse(
        phoneNumberOrders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def phoneNumberOrders
        : Optional[List[zio.aws.chimesdkvoice.model.PhoneNumberOrder.ReadOnly]]
    def nextToken: Optional[String]
    def getPhoneNumberOrders: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.PhoneNumberOrder.ReadOnly
    ]] = AwsError.unwrapOptionField("phoneNumberOrders", phoneNumberOrders)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersResponse
  ) extends zio.aws.chimesdkvoice.model.ListPhoneNumberOrdersResponse.ReadOnly {
    override val phoneNumberOrders: Optional[
      List[zio.aws.chimesdkvoice.model.PhoneNumberOrder.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberOrders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.PhoneNumberOrder.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersResponse
  ): zio.aws.chimesdkvoice.model.ListPhoneNumberOrdersResponse.ReadOnly =
    new Wrapper(impl)
}
