package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString256
import scala.jdk.CollectionConverters._
final case class GetVoiceProfileRequest(voiceProfileId: NonEmptyString256) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileRequest = {
    import GetVoiceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileRequest
      .builder()
      .voiceProfileId(
        NonEmptyString256.unwrap(voiceProfileId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.GetVoiceProfileRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceProfileRequest.wrap(buildAwsValue())
}
object GetVoiceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetVoiceProfileRequest =
      zio.aws.chimesdkvoice.model.GetVoiceProfileRequest(voiceProfileId)
    def voiceProfileId: NonEmptyString256
    def getVoiceProfileId: ZIO[Any, Nothing, NonEmptyString256] =
      ZIO.succeed(voiceProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileRequest
  ) extends zio.aws.chimesdkvoice.model.GetVoiceProfileRequest.ReadOnly {
    override val voiceProfileId: NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString256(impl.voiceProfileId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileRequest
  ): zio.aws.chimesdkvoice.model.GetVoiceProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
