package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorProxyResponse(
    proxy: Optional[zio.aws.chimesdkvoice.model.Proxy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorProxyResponse = {
    import GetVoiceConnectorProxyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorProxyResponse
      .builder()
      .optionallyWith(proxy.map(value => value.buildAwsValue()))(_.proxy)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyResponse
      .wrap(buildAwsValue())
}
object GetVoiceConnectorProxyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorProxyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyResponse =
      zio.aws.chimesdkvoice.model
        .GetVoiceConnectorProxyResponse(proxy.map(value => value.asEditable))
    def proxy: Optional[zio.aws.chimesdkvoice.model.Proxy.ReadOnly]
    def getProxy
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.Proxy.ReadOnly] =
      AwsError.unwrapOptionField("proxy", proxy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorProxyResponse
  ) extends zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyResponse.ReadOnly {
    override val proxy: Optional[zio.aws.chimesdkvoice.model.Proxy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxy())
        .map(value => zio.aws.chimesdkvoice.model.Proxy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorProxyResponse
  ): zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyResponse.ReadOnly =
    new Wrapper(impl)
}
