package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetProxySessionResponse(
    proxySession: Optional[zio.aws.chimesdkvoice.model.ProxySession] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetProxySessionResponse = {
    import GetProxySessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetProxySessionResponse
      .builder()
      .optionallyWith(proxySession.map(value => value.buildAwsValue()))(
        _.proxySession
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.GetProxySessionResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetProxySessionResponse.wrap(buildAwsValue())
}
object GetProxySessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetProxySessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetProxySessionResponse =
      zio.aws.chimesdkvoice.model
        .GetProxySessionResponse(proxySession.map(value => value.asEditable))
    def proxySession
        : Optional[zio.aws.chimesdkvoice.model.ProxySession.ReadOnly]
    def getProxySession: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.ProxySession.ReadOnly
    ] = AwsError.unwrapOptionField("proxySession", proxySession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetProxySessionResponse
  ) extends zio.aws.chimesdkvoice.model.GetProxySessionResponse.ReadOnly {
    override val proxySession
        : Optional[zio.aws.chimesdkvoice.model.ProxySession.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxySession())
        .map(value => zio.aws.chimesdkvoice.model.ProxySession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetProxySessionResponse
  ): zio.aws.chimesdkvoice.model.GetProxySessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
