package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString256
import scala.jdk.CollectionConverters._
final case class DeleteVoiceProfileDomainRequest(
    voiceProfileDomainId: NonEmptyString256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileDomainRequest = {
    import DeleteVoiceProfileDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileDomainRequest
      .builder()
      .voiceProfileDomainId(
        NonEmptyString256.unwrap(voiceProfileDomainId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.DeleteVoiceProfileDomainRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.DeleteVoiceProfileDomainRequest
      .wrap(buildAwsValue())
}
object DeleteVoiceProfileDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.DeleteVoiceProfileDomainRequest =
      zio.aws.chimesdkvoice.model
        .DeleteVoiceProfileDomainRequest(voiceProfileDomainId)
    def voiceProfileDomainId: NonEmptyString256
    def getVoiceProfileDomainId: ZIO[Any, Nothing, NonEmptyString256] =
      ZIO.succeed(voiceProfileDomainId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileDomainRequest
  ) extends zio.aws.chimesdkvoice.model.DeleteVoiceProfileDomainRequest.ReadOnly {
    override val voiceProfileDomainId: NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString256(impl.voiceProfileDomainId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileDomainRequest
  ): zio.aws.chimesdkvoice.model.DeleteVoiceProfileDomainRequest.ReadOnly =
    new Wrapper(impl)
}
