package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.{SensitiveString, NonEmptyString}
import scala.jdk.CollectionConverters._
final case class DeleteVoiceConnectorTerminationCredentialsRequest(
    voiceConnectorId: NonEmptyString,
    usernames: Iterable[SensitiveString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationCredentialsRequest = {
    import DeleteVoiceConnectorTerminationCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationCredentialsRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .usernames(usernames.map { item =>
        SensitiveString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.DeleteVoiceConnectorTerminationCredentialsRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.DeleteVoiceConnectorTerminationCredentialsRequest
      .wrap(buildAwsValue())
}
object DeleteVoiceConnectorTerminationCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.DeleteVoiceConnectorTerminationCredentialsRequest =
      zio.aws.chimesdkvoice.model
        .DeleteVoiceConnectorTerminationCredentialsRequest(
          voiceConnectorId,
          usernames
        )
    def voiceConnectorId: NonEmptyString
    def usernames: List[SensitiveString]
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getUsernames: ZIO[Any, Nothing, List[SensitiveString]] =
      ZIO.succeed(usernames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationCredentialsRequest
  ) extends zio.aws.chimesdkvoice.model.DeleteVoiceConnectorTerminationCredentialsRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorId())
    override val usernames: List[SensitiveString] = impl
      .usernames()
      .asScala
      .map { item =>
        zio.aws.chimesdkvoice.model.primitives.SensitiveString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationCredentialsRequest
  ): zio.aws.chimesdkvoice.model.DeleteVoiceConnectorTerminationCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
