package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class DeleteSipMediaApplicationRequest(
    sipMediaApplicationId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipMediaApplicationRequest = {
    import DeleteSipMediaApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipMediaApplicationRequest
      .builder()
      .sipMediaApplicationId(
        NonEmptyString.unwrap(sipMediaApplicationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.DeleteSipMediaApplicationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.DeleteSipMediaApplicationRequest
      .wrap(buildAwsValue())
}
object DeleteSipMediaApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipMediaApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.DeleteSipMediaApplicationRequest =
      zio.aws.chimesdkvoice.model
        .DeleteSipMediaApplicationRequest(sipMediaApplicationId)
    def sipMediaApplicationId: NonEmptyString
    def getSipMediaApplicationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(sipMediaApplicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipMediaApplicationRequest
  ) extends zio.aws.chimesdkvoice.model.DeleteSipMediaApplicationRequest.ReadOnly {
    override val sipMediaApplicationId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.sipMediaApplicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipMediaApplicationRequest
  ): zio.aws.chimesdkvoice.model.DeleteSipMediaApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
