package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVoiceProfileResponse(
    voiceProfile: Optional[zio.aws.chimesdkvoice.model.VoiceProfile] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileResponse = {
    import CreateVoiceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileResponse
      .builder()
      .optionallyWith(voiceProfile.map(value => value.buildAwsValue()))(
        _.voiceProfile
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.CreateVoiceProfileResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.CreateVoiceProfileResponse.wrap(buildAwsValue())
}
object CreateVoiceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.CreateVoiceProfileResponse =
      zio.aws.chimesdkvoice.model
        .CreateVoiceProfileResponse(voiceProfile.map(value => value.asEditable))
    def voiceProfile
        : Optional[zio.aws.chimesdkvoice.model.VoiceProfile.ReadOnly]
    def getVoiceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("voiceProfile", voiceProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileResponse
  ) extends zio.aws.chimesdkvoice.model.CreateVoiceProfileResponse.ReadOnly {
    override val voiceProfile
        : Optional[zio.aws.chimesdkvoice.model.VoiceProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceProfile())
        .map(value => zio.aws.chimesdkvoice.model.VoiceProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileResponse
  ): zio.aws.chimesdkvoice.model.CreateVoiceProfileResponse.ReadOnly =
    new Wrapper(impl)
}
