package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSipMediaApplicationResponse(
    sipMediaApplication: Optional[
      zio.aws.chimesdkvoice.model.SipMediaApplication
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationResponse = {
    import CreateSipMediaApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationResponse
      .builder()
      .optionallyWith(sipMediaApplication.map(value => value.buildAwsValue()))(
        _.sipMediaApplication
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.CreateSipMediaApplicationResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.CreateSipMediaApplicationResponse
      .wrap(buildAwsValue())
}
object CreateSipMediaApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.CreateSipMediaApplicationResponse =
      zio.aws.chimesdkvoice.model.CreateSipMediaApplicationResponse(
        sipMediaApplication.map(value => value.asEditable)
      )
    def sipMediaApplication
        : Optional[zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly]
    def getSipMediaApplication: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly
    ] = AwsError.unwrapOptionField("sipMediaApplication", sipMediaApplication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationResponse
  ) extends zio.aws.chimesdkvoice.model.CreateSipMediaApplicationResponse.ReadOnly {
    override val sipMediaApplication
        : Optional[zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipMediaApplication())
        .map(value =>
          zio.aws.chimesdkvoice.model.SipMediaApplication.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationResponse
  ): zio.aws.chimesdkvoice.model.CreateSipMediaApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
