package zio.aws.chimesdkvoice
import zio.aws.chimesdkvoice.model.GetSipRuleResponse.ReadOnly
import zio.aws.chimesdkvoice.model.primitives.E164PhoneNumber
import zio.aws.chimesdkvoice.model.{
  CreateVoiceConnectorGroupRequest,
  UpdateVoiceConnectorRequest,
  GetVoiceConnectorOriginationRequest,
  UpdatePhoneNumberSettingsRequest,
  CreateVoiceConnectorRequest,
  GetProxySessionRequest,
  DeleteSipMediaApplicationRequest,
  StartVoiceToneAnalysisTaskRequest,
  ListVoiceConnectorTerminationCredentialsRequest,
  UpdateGlobalSettingsRequest,
  PutVoiceConnectorLoggingConfigurationRequest,
  UpdateSipMediaApplicationRequest,
  DeleteVoiceConnectorOriginationRequest,
  SearchAvailablePhoneNumbersRequest,
  GetVoiceConnectorProxyRequest,
  UpdateSipMediaApplicationCallRequest,
  StopSpeakerSearchTaskRequest,
  DisassociatePhoneNumbersFromVoiceConnectorGroupRequest,
  GetVoiceConnectorLoggingConfigurationRequest,
  GetSipRuleRequest,
  CreateSipMediaApplicationRequest,
  AssociatePhoneNumbersWithVoiceConnectorRequest,
  AssociatePhoneNumbersWithVoiceConnectorGroupRequest,
  CreateProxySessionRequest,
  DeleteVoiceConnectorTerminationRequest,
  CreateVoiceProfileRequest,
  DeleteVoiceConnectorProxyRequest,
  UpdatePhoneNumberRequest,
  GetVoiceConnectorRequest,
  ListTagsForResourceRequest,
  CreatePhoneNumberOrderRequest,
  CreateVoiceProfileDomainRequest,
  PutSipMediaApplicationLoggingConfigurationRequest,
  PutVoiceConnectorOriginationRequest,
  ListVoiceConnectorGroupsRequest,
  PutVoiceConnectorTerminationRequest,
  GetVoiceConnectorGroupRequest,
  StartSpeakerSearchTaskRequest,
  DeletePhoneNumberRequest,
  DeleteProxySessionRequest,
  UpdateProxySessionRequest,
  BatchDeletePhoneNumberRequest,
  ListSipRulesRequest,
  ListProxySessionsRequest,
  DeleteVoiceConnectorGroupRequest,
  ListVoiceProfileDomainsRequest,
  ListPhoneNumbersRequest,
  PutSipMediaApplicationAlexaSkillConfigurationRequest,
  DeleteVoiceConnectorRequest,
  GetPhoneNumberOrderRequest,
  CreateSipRuleRequest,
  PutVoiceConnectorTerminationCredentialsRequest,
  DeleteVoiceConnectorTerminationCredentialsRequest,
  GetSipMediaApplicationRequest,
  DeleteVoiceConnectorStreamingConfigurationRequest,
  PutVoiceConnectorStreamingConfigurationRequest,
  DeleteVoiceConnectorEmergencyCallingConfigurationRequest,
  PutVoiceConnectorEmergencyCallingConfigurationRequest,
  GetPhoneNumberRequest,
  StopVoiceToneAnalysisTaskRequest,
  GetVoiceProfileDomainRequest,
  ValidateE911AddressRequest,
  UpdateVoiceConnectorGroupRequest,
  UntagResourceRequest,
  CreateSipMediaApplicationCallRequest,
  GetSipMediaApplicationLoggingConfigurationRequest,
  UpdateVoiceProfileDomainRequest,
  RestorePhoneNumberRequest,
  ListSupportedPhoneNumberCountriesRequest,
  DeleteVoiceProfileRequest,
  GetVoiceProfileRequest,
  UpdateSipRuleRequest,
  DeleteVoiceProfileDomainRequest,
  UpdateVoiceProfileRequest,
  ListVoiceProfilesRequest,
  ListSipMediaApplicationsRequest,
  GetSpeakerSearchTaskRequest,
  DeleteSipRuleRequest,
  ListVoiceConnectorsRequest,
  GetVoiceConnectorTerminationHealthRequest,
  GetVoiceConnectorStreamingConfigurationRequest,
  BatchUpdatePhoneNumberRequest,
  GetVoiceConnectorEmergencyCallingConfigurationRequest,
  GetVoiceConnectorTerminationRequest,
  GetSipMediaApplicationAlexaSkillConfigurationRequest,
  ListPhoneNumberOrdersRequest,
  PutVoiceConnectorProxyRequest,
  TagResourceRequest,
  GetVoiceToneAnalysisTaskRequest,
  DisassociatePhoneNumbersFromVoiceConnectorRequest
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.chimesdkvoice.{
  ChimeSdkVoiceAsyncClientBuilder,
  ChimeSdkVoiceAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.chimesdkvoice.model.{
  CreateSipMediaApplicationCallResponse,
  PutVoiceConnectorEmergencyCallingConfigurationResponse,
  UpdateSipRuleResponse,
  GetVoiceConnectorEmergencyCallingConfigurationResponse,
  DeleteVoiceProfileResponse,
  GetSipMediaApplicationResponse,
  DeleteSipRuleResponse,
  GetVoiceToneAnalysisTaskResponse,
  VoiceProfileDomainSummary,
  GetVoiceConnectorTerminationResponse,
  GetPhoneNumberSettingsRequest,
  UpdateVoiceProfileDomainResponse,
  PutSipMediaApplicationLoggingConfigurationResponse,
  PhoneNumberOrder,
  DeleteVoiceConnectorTerminationCredentialsResponse,
  AssociatePhoneNumbersWithVoiceConnectorGroupResponse,
  SearchAvailablePhoneNumbersResponse,
  PutSipMediaApplicationAlexaSkillConfigurationResponse,
  DeleteVoiceConnectorTerminationResponse,
  GetVoiceConnectorGroupResponse,
  BatchDeletePhoneNumberResponse,
  CreateProxySessionResponse,
  CreateVoiceProfileResponse,
  CreateVoiceProfileDomainResponse,
  DeletePhoneNumberResponse,
  DeleteVoiceConnectorOriginationResponse,
  UpdateSipMediaApplicationResponse,
  ListPhoneNumberOrdersResponse,
  StopSpeakerSearchTaskResponse,
  GetPhoneNumberSettingsResponse,
  CreateSipMediaApplicationResponse,
  SipMediaApplication,
  DeleteProxySessionResponse,
  ListVoiceConnectorsResponse,
  UpdateVoiceConnectorGroupResponse,
  PutVoiceConnectorLoggingConfigurationResponse,
  StopVoiceToneAnalysisTaskResponse,
  GetVoiceConnectorProxyResponse,
  AssociatePhoneNumbersWithVoiceConnectorResponse,
  VoiceConnectorGroup,
  ListVoiceProfileDomainsResponse,
  GetVoiceConnectorTerminationHealthResponse,
  CreatePhoneNumberOrderResponse,
  ListProxySessionsResponse,
  UpdateVoiceProfileResponse,
  GetProxySessionResponse,
  GetVoiceProfileDomainResponse,
  ProxySession,
  DeleteVoiceConnectorEmergencyCallingConfigurationResponse,
  ListTagsForResourceResponse,
  UpdateSipMediaApplicationCallResponse,
  ListAvailableVoiceConnectorRegionsRequest,
  SipRule,
  ListAvailableVoiceConnectorRegionsResponse,
  UntagResourceResponse,
  CreateVoiceConnectorResponse,
  DeleteVoiceConnectorGroupResponse,
  PutVoiceConnectorProxyResponse,
  UpdateGlobalSettingsResponse,
  GetVoiceConnectorOriginationResponse,
  ListSupportedPhoneNumberCountriesResponse,
  DeleteVoiceConnectorResponse,
  DeleteVoiceProfileDomainResponse,
  DisassociatePhoneNumbersFromVoiceConnectorResponse,
  VoiceProfileSummary,
  CreateVoiceConnectorGroupResponse,
  ListVoiceProfilesResponse,
  PutVoiceConnectorStreamingConfigurationResponse,
  GetVoiceConnectorResponse,
  UpdateProxySessionResponse,
  GetSipMediaApplicationLoggingConfigurationResponse,
  PhoneNumber,
  GetGlobalSettingsResponse,
  ListSipRulesResponse,
  UpdateVoiceConnectorResponse,
  GetVoiceProfileResponse,
  GetSpeakerSearchTaskResponse,
  DeleteVoiceConnectorProxyResponse,
  ListVoiceConnectorGroupsResponse,
  UpdatePhoneNumberResponse,
  StartSpeakerSearchTaskResponse,
  VoiceConnector,
  GetSipMediaApplicationAlexaSkillConfigurationResponse,
  PutVoiceConnectorTerminationCredentialsResponse,
  ListPhoneNumbersResponse,
  UpdatePhoneNumberSettingsResponse,
  GetGlobalSettingsRequest,
  DisassociatePhoneNumbersFromVoiceConnectorGroupResponse,
  GetPhoneNumberResponse,
  CreateSipRuleResponse,
  ListVoiceConnectorTerminationCredentialsResponse,
  BatchUpdatePhoneNumberResponse,
  GetPhoneNumberOrderResponse,
  ValidateE911AddressResponse,
  GetSipRuleResponse,
  TagResourceResponse,
  StartVoiceToneAnalysisTaskResponse,
  DeleteVoiceConnectorStreamingConfigurationResponse,
  DeleteSipMediaApplicationResponse,
  PutVoiceConnectorOriginationResponse,
  GetVoiceConnectorStreamingConfigurationResponse,
  PutVoiceConnectorTerminationResponse,
  RestorePhoneNumberResponse,
  ListSipMediaApplicationsResponse,
  GetVoiceConnectorLoggingConfigurationResponse
}
import scala.jdk.CollectionConverters._
trait ChimeSdkVoice extends AspectSupport[ChimeSdkVoice] {
  val api: ChimeSdkVoiceAsyncClient
  def listSipMediaApplications(
      request: ListSipMediaApplicationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly
  ]
  def listSipMediaApplicationsPaginated(
      request: ListSipMediaApplicationsRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.ListSipMediaApplicationsResponse.ReadOnly
  ]
  def deleteVoiceProfile(request: DeleteVoiceProfileRequest): IO[AwsError, Unit]
  def putVoiceConnectorEmergencyCallingConfiguration(
      request: PutVoiceConnectorEmergencyCallingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
  ]
  def deleteSipRule(request: DeleteSipRuleRequest): IO[AwsError, Unit]
  def putVoiceConnectorProxy(request: PutVoiceConnectorProxyRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyResponse.ReadOnly
  ]
  def createVoiceConnector(request: CreateVoiceConnectorRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.CreateVoiceConnectorResponse.ReadOnly
  ]
  def restorePhoneNumber(request: RestorePhoneNumberRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.RestorePhoneNumberResponse.ReadOnly
  ]
  def putSipMediaApplicationLoggingConfiguration(
      request: PutSipMediaApplicationLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly
  ]
  def getVoiceConnector(request: GetVoiceConnectorRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorResponse.ReadOnly
  ]
  def disassociatePhoneNumbersFromVoiceConnector(
      request: DisassociatePhoneNumbersFromVoiceConnectorRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorResponse.ReadOnly
  ]
  def updateVoiceConnectorGroup(request: UpdateVoiceConnectorGroupRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse.ReadOnly
  ]
  def listSupportedPhoneNumberCountries(
      request: ListSupportedPhoneNumberCountriesRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse.ReadOnly
  ]
  def getVoiceConnectorProxy(request: GetVoiceConnectorProxyRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyResponse.ReadOnly
  ]
  def listVoiceConnectors(
      request: ListVoiceConnectorsRequest
  ): ZStream[Any, AwsError, zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly]
  def listVoiceConnectorsPaginated(request: ListVoiceConnectorsRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.ListVoiceConnectorsResponse.ReadOnly
  ]
  def createVoiceProfileDomain(request: CreateVoiceProfileDomainRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.CreateVoiceProfileDomainResponse.ReadOnly
  ]
  def getVoiceToneAnalysisTask(request: GetVoiceToneAnalysisTaskRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse.ReadOnly
  ]
  def updateSipRule(
      request: UpdateSipRuleRequest
  ): IO[AwsError, zio.aws.chimesdkvoice.model.UpdateSipRuleResponse.ReadOnly]
  def listAvailableVoiceConnectorRegions(): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse.ReadOnly
  ]
  def getVoiceConnectorTermination(
      request: GetVoiceConnectorTerminationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationResponse.ReadOnly
  ]
  def associatePhoneNumbersWithVoiceConnector(
      request: AssociatePhoneNumbersWithVoiceConnectorRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorResponse.ReadOnly
  ]
  def createPhoneNumberOrder(request: CreatePhoneNumberOrderRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderResponse.ReadOnly
  ]
  def deleteVoiceConnectorEmergencyCallingConfiguration(
      request: DeleteVoiceConnectorEmergencyCallingConfigurationRequest
  ): IO[AwsError, Unit]
  def getSipMediaApplicationLoggingConfiguration(
      request: GetSipMediaApplicationLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly
  ]
  def getProxySession(
      request: GetProxySessionRequest
  ): IO[AwsError, zio.aws.chimesdkvoice.model.GetProxySessionResponse.ReadOnly]
  def deletePhoneNumber(request: DeletePhoneNumberRequest): IO[AwsError, Unit]
  def listPhoneNumberOrders(request: ListPhoneNumberOrdersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.chimesdkvoice.model.PhoneNumberOrder.ReadOnly
  ]
  def listPhoneNumberOrdersPaginated(request: ListPhoneNumberOrdersRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.ListPhoneNumberOrdersResponse.ReadOnly
  ]
  def getSpeakerSearchTask(request: GetSpeakerSearchTaskRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskResponse.ReadOnly
  ]
  def listVoiceProfiles(request: ListVoiceProfilesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.chimesdkvoice.model.VoiceProfileSummary.ReadOnly
  ]
  def listVoiceProfilesPaginated(request: ListVoiceProfilesRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.ListVoiceProfilesResponse.ReadOnly
  ]
  def deleteSipMediaApplication(
      request: DeleteSipMediaApplicationRequest
  ): IO[AwsError, Unit]
  def listProxySessions(
      request: ListProxySessionsRequest
  ): ZStream[Any, AwsError, zio.aws.chimesdkvoice.model.ProxySession.ReadOnly]
  def listProxySessionsPaginated(request: ListProxySessionsRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.ListProxySessionsResponse.ReadOnly
  ]
  def deleteVoiceConnectorProxy(
      request: DeleteVoiceConnectorProxyRequest
  ): IO[AwsError, Unit]
  def startSpeakerSearchTask(request: StartSpeakerSearchTaskRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskResponse.ReadOnly
  ]
  def getPhoneNumberOrder(request: GetPhoneNumberOrderRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetPhoneNumberOrderResponse.ReadOnly
  ]
  def updateVoiceConnector(request: UpdateVoiceConnectorRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.UpdateVoiceConnectorResponse.ReadOnly
  ]
  def getSipMediaApplication(request: GetSipMediaApplicationRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetSipMediaApplicationResponse.ReadOnly
  ]
  def stopVoiceToneAnalysisTask(
      request: StopVoiceToneAnalysisTaskRequest
  ): IO[AwsError, Unit]
  def updateSipMediaApplicationCall(
      request: UpdateSipMediaApplicationCallRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse.ReadOnly
  ]
  def updateVoiceProfile(request: UpdateVoiceProfileRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.UpdateVoiceProfileResponse.ReadOnly
  ]
  def deleteVoiceConnectorOrigination(
      request: DeleteVoiceConnectorOriginationRequest
  ): IO[AwsError, Unit]
  def listPhoneNumbers(
      request: ListPhoneNumbersRequest
  ): ZStream[Any, AwsError, zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly]
  def listPhoneNumbersPaginated(
      request: ListPhoneNumbersRequest
  ): IO[AwsError, zio.aws.chimesdkvoice.model.ListPhoneNumbersResponse.ReadOnly]
  def deleteVoiceConnectorTerminationCredentials(
      request: DeleteVoiceConnectorTerminationCredentialsRequest
  ): IO[AwsError, Unit]
  def updatePhoneNumber(request: UpdatePhoneNumberRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.UpdatePhoneNumberResponse.ReadOnly
  ]
  def updateVoiceProfileDomain(request: UpdateVoiceProfileDomainRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.UpdateVoiceProfileDomainResponse.ReadOnly
  ]
  def getVoiceConnectorTerminationHealth(
      request: GetVoiceConnectorTerminationHealthRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly
  ]
  def getPhoneNumber(
      request: GetPhoneNumberRequest
  ): IO[AwsError, zio.aws.chimesdkvoice.model.GetPhoneNumberResponse.ReadOnly]
  def putVoiceConnectorLoggingConfiguration(
      request: PutVoiceConnectorLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly
  ]
  def searchAvailablePhoneNumbers(
      request: SearchAvailablePhoneNumbersRequest
  ): ZStream[Any, AwsError, E164PhoneNumber]
  def searchAvailablePhoneNumbersPaginated(
      request: SearchAvailablePhoneNumbersRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.SearchAvailablePhoneNumbersResponse.ReadOnly
  ]
  def listVoiceProfileDomains(request: ListVoiceProfileDomainsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary.ReadOnly
  ]
  def listVoiceProfileDomainsPaginated(
      request: ListVoiceProfileDomainsRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.ListVoiceProfileDomainsResponse.ReadOnly
  ]
  def listVoiceConnectorTerminationCredentials(
      request: ListVoiceConnectorTerminationCredentialsRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.ListVoiceConnectorTerminationCredentialsResponse.ReadOnly
  ]
  def untagResource(request: UntagResourceRequest): IO[AwsError, Unit]
  def updateSipMediaApplication(request: UpdateSipMediaApplicationRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationResponse.ReadOnly
  ]
  def getSipRule(request: GetSipRuleRequest): IO[AwsError, ReadOnly]
  def updatePhoneNumberSettings(
      request: UpdatePhoneNumberSettingsRequest
  ): IO[AwsError, Unit]
  def putSipMediaApplicationAlexaSkillConfiguration(
      request: PutSipMediaApplicationAlexaSkillConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationResponse.ReadOnly
  ]
  def getVoiceConnectorStreamingConfiguration(
      request: GetVoiceConnectorStreamingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly
  ]
  def createVoiceConnectorGroup(request: CreateVoiceConnectorGroupRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupResponse.ReadOnly
  ]
  def deleteProxySession(request: DeleteProxySessionRequest): IO[AwsError, Unit]
  def startVoiceToneAnalysisTask(
      request: StartVoiceToneAnalysisTaskRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.StartVoiceToneAnalysisTaskResponse.ReadOnly
  ]
  def getVoiceProfileDomain(request: GetVoiceProfileDomainRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceProfileDomainResponse.ReadOnly
  ]
  def listSipRules(
      request: ListSipRulesRequest
  ): ZStream[Any, AwsError, zio.aws.chimesdkvoice.model.SipRule.ReadOnly]
  def listSipRulesPaginated(
      request: ListSipRulesRequest
  ): IO[AwsError, zio.aws.chimesdkvoice.model.ListSipRulesResponse.ReadOnly]
  def getGlobalSettings(): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetGlobalSettingsResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.ListTagsForResourceResponse.ReadOnly
  ]
  def putVoiceConnectorTermination(
      request: PutVoiceConnectorTerminationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationResponse.ReadOnly
  ]
  def associatePhoneNumbersWithVoiceConnectorGroup(
      request: AssociatePhoneNumbersWithVoiceConnectorGroupRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[AwsError, Unit]
  def batchDeletePhoneNumber(request: BatchDeletePhoneNumberRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.BatchDeletePhoneNumberResponse.ReadOnly
  ]
  def disassociatePhoneNumbersFromVoiceConnectorGroup(
      request: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.ReadOnly
  ]
  def putVoiceConnectorTerminationCredentials(
      request: PutVoiceConnectorTerminationCredentialsRequest
  ): IO[AwsError, Unit]
  def createSipMediaApplicationCall(
      request: CreateSipMediaApplicationCallRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallResponse.ReadOnly
  ]
  def getVoiceProfile(
      request: GetVoiceProfileRequest
  ): IO[AwsError, zio.aws.chimesdkvoice.model.GetVoiceProfileResponse.ReadOnly]
  def getVoiceConnectorLoggingConfiguration(
      request: GetVoiceConnectorLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly
  ]
  def deleteVoiceProfileDomain(
      request: DeleteVoiceProfileDomainRequest
  ): IO[AwsError, Unit]
  def deleteVoiceConnectorGroup(
      request: DeleteVoiceConnectorGroupRequest
  ): IO[AwsError, Unit]
  def putVoiceConnectorStreamingConfiguration(
      request: PutVoiceConnectorStreamingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationResponse.ReadOnly
  ]
  def getVoiceConnectorEmergencyCallingConfiguration(
      request: GetVoiceConnectorEmergencyCallingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
  ]
  def deleteVoiceConnectorTermination(
      request: DeleteVoiceConnectorTerminationRequest
  ): IO[AwsError, Unit]
  def deleteVoiceConnectorStreamingConfiguration(
      request: DeleteVoiceConnectorStreamingConfigurationRequest
  ): IO[AwsError, Unit]
  def putVoiceConnectorOrigination(
      request: PutVoiceConnectorOriginationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationResponse.ReadOnly
  ]
  def stopSpeakerSearchTask(
      request: StopSpeakerSearchTaskRequest
  ): IO[AwsError, Unit]
  def getPhoneNumberSettings(): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetPhoneNumberSettingsResponse.ReadOnly
  ]
  def updateProxySession(request: UpdateProxySessionRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.UpdateProxySessionResponse.ReadOnly
  ]
  def updateGlobalSettings(
      request: UpdateGlobalSettingsRequest
  ): IO[AwsError, Unit]
  def listVoiceConnectorGroups(
      request: ListVoiceConnectorGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.chimesdkvoice.model.VoiceConnectorGroup.ReadOnly
  ]
  def listVoiceConnectorGroupsPaginated(
      request: ListVoiceConnectorGroupsRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsResponse.ReadOnly
  ]
  def createSipRule(
      request: CreateSipRuleRequest
  ): IO[AwsError, zio.aws.chimesdkvoice.model.CreateSipRuleResponse.ReadOnly]
  def getVoiceConnectorGroup(request: GetVoiceConnectorGroupRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorGroupResponse.ReadOnly
  ]
  def createProxySession(request: CreateProxySessionRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.CreateProxySessionResponse.ReadOnly
  ]
  def getVoiceConnectorOrigination(
      request: GetVoiceConnectorOriginationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationResponse.ReadOnly
  ]
  def createSipMediaApplication(request: CreateSipMediaApplicationRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.CreateSipMediaApplicationResponse.ReadOnly
  ]
  def createVoiceProfile(request: CreateVoiceProfileRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.CreateVoiceProfileResponse.ReadOnly
  ]
  def validateE911Address(request: ValidateE911AddressRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.ValidateE911AddressResponse.ReadOnly
  ]
  def deleteVoiceConnector(
      request: DeleteVoiceConnectorRequest
  ): IO[AwsError, Unit]
  def batchUpdatePhoneNumber(request: BatchUpdatePhoneNumberRequest): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.BatchUpdatePhoneNumberResponse.ReadOnly
  ]
  def getSipMediaApplicationAlexaSkillConfiguration(
      request: GetSipMediaApplicationAlexaSkillConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationResponse.ReadOnly
  ]
}
object ChimeSdkVoice {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ChimeSdkVoice] = customized(
    identity
  )
  def customized(
      customization: ChimeSdkVoiceAsyncClientBuilder => ChimeSdkVoiceAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ChimeSdkVoice] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ChimeSdkVoiceAsyncClientBuilder => ChimeSdkVoiceAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ChimeSdkVoice] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ChimeSdkVoiceAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[ChimeSdkVoiceAsyncClient, ChimeSdkVoiceAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      ChimeSdkVoiceAsyncClient,
      ChimeSdkVoiceAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ChimeSdkVoiceImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ChimeSdkVoiceImpl[R](
      override val api: ChimeSdkVoiceAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ChimeSdkVoice
      with AwsServiceBase[R] {
    override val serviceName: String = "ChimeSdkVoice"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ChimeSdkVoiceImpl[R1] = new ChimeSdkVoiceImpl(api, newAspect, r)
    def listSipMediaApplications(
        request: ListSipMediaApplicationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest,
      ListSipMediaApplicationsResponse,
      SipMediaApplication
    ](
      "listSipMediaApplications",
      api.listSipMediaApplications,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.sipMediaApplications().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.chimesdkvoice.model.SipMediaApplication.wrap(item))
      .provideEnvironment(r)
    def listSipMediaApplicationsPaginated(
        request: ListSipMediaApplicationsRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.ListSipMediaApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest,
      ListSipMediaApplicationsResponse
    ]("listSipMediaApplications", api.listSipMediaApplications)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.ListSipMediaApplicationsResponse.wrap)
      .provideEnvironment(r)
    def deleteVoiceProfile(
        request: DeleteVoiceProfileRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileRequest,
      DeleteVoiceProfileResponse
    ]("deleteVoiceProfile", api.deleteVoiceProfile)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putVoiceConnectorEmergencyCallingConfiguration(
        request: PutVoiceConnectorEmergencyCallingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationRequest,
      PutVoiceConnectorEmergencyCallingConfigurationResponse
    ](
      "putVoiceConnectorEmergencyCallingConfiguration",
      api.putVoiceConnectorEmergencyCallingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteSipRule(request: DeleteSipRuleRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipRuleRequest,
        DeleteSipRuleResponse
      ]("deleteSipRule", api.deleteSipRule)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def putVoiceConnectorProxy(request: PutVoiceConnectorProxyRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorProxyRequest,
      PutVoiceConnectorProxyResponse
    ]("putVoiceConnectorProxy", api.putVoiceConnectorProxy)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyResponse.wrap)
      .provideEnvironment(r)
    def createVoiceConnector(request: CreateVoiceConnectorRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.CreateVoiceConnectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorRequest,
      CreateVoiceConnectorResponse
    ]("createVoiceConnector", api.createVoiceConnector)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.CreateVoiceConnectorResponse.wrap)
      .provideEnvironment(r)
    def restorePhoneNumber(request: RestorePhoneNumberRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.RestorePhoneNumberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.RestorePhoneNumberRequest,
      RestorePhoneNumberResponse
    ]("restorePhoneNumber", api.restorePhoneNumber)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.RestorePhoneNumberResponse.wrap)
      .provideEnvironment(r)
    def putSipMediaApplicationLoggingConfiguration(
        request: PutSipMediaApplicationLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationRequest,
      PutSipMediaApplicationLoggingConfigurationResponse
    ](
      "putSipMediaApplicationLoggingConfiguration",
      api.putSipMediaApplicationLoggingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def getVoiceConnector(request: GetVoiceConnectorRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetVoiceConnectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorRequest,
      GetVoiceConnectorResponse
    ]("getVoiceConnector", api.getVoiceConnector)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.GetVoiceConnectorResponse.wrap)
      .provideEnvironment(r)
    def disassociatePhoneNumbersFromVoiceConnector(
        request: DisassociatePhoneNumbersFromVoiceConnectorRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorRequest,
      DisassociatePhoneNumbersFromVoiceConnectorResponse
    ](
      "disassociatePhoneNumbersFromVoiceConnector",
      api.disassociatePhoneNumbersFromVoiceConnector
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorResponse.wrap
      )
      .provideEnvironment(r)
    def updateVoiceConnectorGroup(
        request: UpdateVoiceConnectorGroupRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorGroupRequest,
      UpdateVoiceConnectorGroupResponse
    ]("updateVoiceConnectorGroup", api.updateVoiceConnectorGroup)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse.wrap)
      .provideEnvironment(r)
    def listSupportedPhoneNumberCountries(
        request: ListSupportedPhoneNumberCountriesRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.ListSupportedPhoneNumberCountriesRequest,
      ListSupportedPhoneNumberCountriesResponse
    ](
      "listSupportedPhoneNumberCountries",
      api.listSupportedPhoneNumberCountries
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse.wrap
      )
      .provideEnvironment(r)
    def getVoiceConnectorProxy(request: GetVoiceConnectorProxyRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorProxyRequest,
      GetVoiceConnectorProxyResponse
    ]("getVoiceConnectorProxy", api.getVoiceConnectorProxy)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyResponse.wrap)
      .provideEnvironment(r)
    def listVoiceConnectors(request: ListVoiceConnectorsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest,
      ListVoiceConnectorsResponse,
      VoiceConnector
    ](
      "listVoiceConnectors",
      api.listVoiceConnectors,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.voiceConnectors().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.chimesdkvoice.model.VoiceConnector.wrap(item))
      .provideEnvironment(r)
    def listVoiceConnectorsPaginated(request: ListVoiceConnectorsRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.ListVoiceConnectorsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest,
      ListVoiceConnectorsResponse
    ]("listVoiceConnectors", api.listVoiceConnectors)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.ListVoiceConnectorsResponse.wrap)
      .provideEnvironment(r)
    def createVoiceProfileDomain(request: CreateVoiceProfileDomainRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.CreateVoiceProfileDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileDomainRequest,
      CreateVoiceProfileDomainResponse
    ]("createVoiceProfileDomain", api.createVoiceProfileDomain)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.CreateVoiceProfileDomainResponse.wrap)
      .provideEnvironment(r)
    def getVoiceToneAnalysisTask(request: GetVoiceToneAnalysisTaskRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceToneAnalysisTaskRequest,
      GetVoiceToneAnalysisTaskResponse
    ]("getVoiceToneAnalysisTask", api.getVoiceToneAnalysisTask)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse.wrap)
      .provideEnvironment(r)
    def updateSipRule(request: UpdateSipRuleRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.UpdateSipRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipRuleRequest,
      UpdateSipRuleResponse
    ]("updateSipRule", api.updateSipRule)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.UpdateSipRuleResponse.wrap)
      .provideEnvironment(r)
    def listAvailableVoiceConnectorRegions(): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAvailableVoiceConnectorRegionsRequest,
      ListAvailableVoiceConnectorRegionsResponse
    ](
      "listAvailableVoiceConnectorRegions",
      api.listAvailableVoiceConnectorRegions
    )(ListAvailableVoiceConnectorRegionsRequest.builder().build())
      .map(
        zio.aws.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse.wrap
      )
      .provideEnvironment(r)
    def getVoiceConnectorTermination(
        request: GetVoiceConnectorTerminationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorTerminationRequest,
      GetVoiceConnectorTerminationResponse
    ]("getVoiceConnectorTermination", api.getVoiceConnectorTermination)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationResponse.wrap)
      .provideEnvironment(r)
    def associatePhoneNumbersWithVoiceConnector(
        request: AssociatePhoneNumbersWithVoiceConnectorRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorRequest,
      AssociatePhoneNumbersWithVoiceConnectorResponse
    ](
      "associatePhoneNumbersWithVoiceConnector",
      api.associatePhoneNumbersWithVoiceConnector
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorResponse.wrap
      )
      .provideEnvironment(r)
    def createPhoneNumberOrder(request: CreatePhoneNumberOrderRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.CreatePhoneNumberOrderRequest,
      CreatePhoneNumberOrderResponse
    ]("createPhoneNumberOrder", api.createPhoneNumberOrder)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderResponse.wrap)
      .provideEnvironment(r)
    def deleteVoiceConnectorEmergencyCallingConfiguration(
        request: DeleteVoiceConnectorEmergencyCallingConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest,
      DeleteVoiceConnectorEmergencyCallingConfigurationResponse
    ](
      "deleteVoiceConnectorEmergencyCallingConfiguration",
      api.deleteVoiceConnectorEmergencyCallingConfiguration
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getSipMediaApplicationLoggingConfiguration(
        request: GetSipMediaApplicationLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationRequest,
      GetSipMediaApplicationLoggingConfigurationResponse
    ](
      "getSipMediaApplicationLoggingConfiguration",
      api.getSipMediaApplicationLoggingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def getProxySession(request: GetProxySessionRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetProxySessionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetProxySessionRequest,
      GetProxySessionResponse
    ]("getProxySession", api.getProxySession)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.GetProxySessionResponse.wrap)
      .provideEnvironment(r)
    def deletePhoneNumber(
        request: DeletePhoneNumberRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.DeletePhoneNumberRequest,
      DeletePhoneNumberResponse
    ]("deletePhoneNumber", api.deletePhoneNumber)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def listPhoneNumberOrders(request: ListPhoneNumberOrdersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.PhoneNumberOrder.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersRequest,
      ListPhoneNumberOrdersResponse,
      PhoneNumberOrder
    ](
      "listPhoneNumberOrders",
      api.listPhoneNumberOrders,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.phoneNumberOrders().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.chimesdkvoice.model.PhoneNumberOrder.wrap(item))
      .provideEnvironment(r)
    def listPhoneNumberOrdersPaginated(
        request: ListPhoneNumberOrdersRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.ListPhoneNumberOrdersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersRequest,
      ListPhoneNumberOrdersResponse
    ]("listPhoneNumberOrders", api.listPhoneNumberOrders)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.ListPhoneNumberOrdersResponse.wrap)
      .provideEnvironment(r)
    def getSpeakerSearchTask(request: GetSpeakerSearchTaskRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetSpeakerSearchTaskRequest,
      GetSpeakerSearchTaskResponse
    ]("getSpeakerSearchTask", api.getSpeakerSearchTask)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskResponse.wrap)
      .provideEnvironment(r)
    def listVoiceProfiles(request: ListVoiceProfilesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceProfileSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest,
      ListVoiceProfilesResponse,
      VoiceProfileSummary
    ](
      "listVoiceProfiles",
      api.listVoiceProfiles,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.voiceProfiles().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.chimesdkvoice.model.VoiceProfileSummary.wrap(item))
      .provideEnvironment(r)
    def listVoiceProfilesPaginated(request: ListVoiceProfilesRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.ListVoiceProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest,
      ListVoiceProfilesResponse
    ]("listVoiceProfiles", api.listVoiceProfiles)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.ListVoiceProfilesResponse.wrap)
      .provideEnvironment(r)
    def deleteSipMediaApplication(
        request: DeleteSipMediaApplicationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipMediaApplicationRequest,
      DeleteSipMediaApplicationResponse
    ]("deleteSipMediaApplication", api.deleteSipMediaApplication)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listProxySessions(request: ListProxySessionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.ProxySession.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsRequest,
      ListProxySessionsResponse,
      ProxySession
    ](
      "listProxySessions",
      api.listProxySessions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.proxySessions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.chimesdkvoice.model.ProxySession.wrap(item))
      .provideEnvironment(r)
    def listProxySessionsPaginated(request: ListProxySessionsRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.ListProxySessionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsRequest,
      ListProxySessionsResponse
    ]("listProxySessions", api.listProxySessions)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.ListProxySessionsResponse.wrap)
      .provideEnvironment(r)
    def deleteVoiceConnectorProxy(
        request: DeleteVoiceConnectorProxyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorProxyRequest,
      DeleteVoiceConnectorProxyResponse
    ]("deleteVoiceConnectorProxy", api.deleteVoiceConnectorProxy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def startSpeakerSearchTask(request: StartSpeakerSearchTaskRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.StartSpeakerSearchTaskRequest,
      StartSpeakerSearchTaskResponse
    ]("startSpeakerSearchTask", api.startSpeakerSearchTask)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskResponse.wrap)
      .provideEnvironment(r)
    def getPhoneNumberOrder(request: GetPhoneNumberOrderRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetPhoneNumberOrderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberOrderRequest,
      GetPhoneNumberOrderResponse
    ]("getPhoneNumberOrder", api.getPhoneNumberOrder)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.GetPhoneNumberOrderResponse.wrap)
      .provideEnvironment(r)
    def updateVoiceConnector(request: UpdateVoiceConnectorRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.UpdateVoiceConnectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorRequest,
      UpdateVoiceConnectorResponse
    ]("updateVoiceConnector", api.updateVoiceConnector)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.UpdateVoiceConnectorResponse.wrap)
      .provideEnvironment(r)
    def getSipMediaApplication(request: GetSipMediaApplicationRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetSipMediaApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationRequest,
      GetSipMediaApplicationResponse
    ]("getSipMediaApplication", api.getSipMediaApplication)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.GetSipMediaApplicationResponse.wrap)
      .provideEnvironment(r)
    def stopVoiceToneAnalysisTask(
        request: StopVoiceToneAnalysisTaskRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.StopVoiceToneAnalysisTaskRequest,
      StopVoiceToneAnalysisTaskResponse
    ]("stopVoiceToneAnalysisTask", api.stopVoiceToneAnalysisTask)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateSipMediaApplicationCall(
        request: UpdateSipMediaApplicationCallRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipMediaApplicationCallRequest,
      UpdateSipMediaApplicationCallResponse
    ]("updateSipMediaApplicationCall", api.updateSipMediaApplicationCall)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse.wrap
    ).provideEnvironment(r)
    def updateVoiceProfile(request: UpdateVoiceProfileRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.UpdateVoiceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileRequest,
      UpdateVoiceProfileResponse
    ]("updateVoiceProfile", api.updateVoiceProfile)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.UpdateVoiceProfileResponse.wrap)
      .provideEnvironment(r)
    def deleteVoiceConnectorOrigination(
        request: DeleteVoiceConnectorOriginationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorOriginationRequest,
      DeleteVoiceConnectorOriginationResponse
    ]("deleteVoiceConnectorOrigination", api.deleteVoiceConnectorOrigination)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listPhoneNumbers(request: ListPhoneNumbersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest,
      ListPhoneNumbersResponse,
      PhoneNumber
    ](
      "listPhoneNumbers",
      api.listPhoneNumbers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.phoneNumbers().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.chimesdkvoice.model.PhoneNumber.wrap(item))
      .provideEnvironment(r)
    def listPhoneNumbersPaginated(request: ListPhoneNumbersRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.ListPhoneNumbersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest,
      ListPhoneNumbersResponse
    ]("listPhoneNumbers", api.listPhoneNumbers)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.ListPhoneNumbersResponse.wrap)
      .provideEnvironment(r)
    def deleteVoiceConnectorTerminationCredentials(
        request: DeleteVoiceConnectorTerminationCredentialsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationCredentialsRequest,
      DeleteVoiceConnectorTerminationCredentialsResponse
    ](
      "deleteVoiceConnectorTerminationCredentials",
      api.deleteVoiceConnectorTerminationCredentials
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updatePhoneNumber(request: UpdatePhoneNumberRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.UpdatePhoneNumberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequest,
      UpdatePhoneNumberResponse
    ]("updatePhoneNumber", api.updatePhoneNumber)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.UpdatePhoneNumberResponse.wrap)
      .provideEnvironment(r)
    def updateVoiceProfileDomain(request: UpdateVoiceProfileDomainRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.UpdateVoiceProfileDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileDomainRequest,
      UpdateVoiceProfileDomainResponse
    ]("updateVoiceProfileDomain", api.updateVoiceProfileDomain)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.UpdateVoiceProfileDomainResponse.wrap)
      .provideEnvironment(r)
    def getVoiceConnectorTerminationHealth(
        request: GetVoiceConnectorTerminationHealthRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorTerminationHealthRequest,
      GetVoiceConnectorTerminationHealthResponse
    ](
      "getVoiceConnectorTerminationHealth",
      api.getVoiceConnectorTerminationHealth
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse.wrap
      )
      .provideEnvironment(r)
    def getPhoneNumber(request: GetPhoneNumberRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetPhoneNumberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberRequest,
      GetPhoneNumberResponse
    ]("getPhoneNumber", api.getPhoneNumber)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.GetPhoneNumberResponse.wrap)
      .provideEnvironment(r)
    def putVoiceConnectorLoggingConfiguration(
        request: PutVoiceConnectorLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationRequest,
      PutVoiceConnectorLoggingConfigurationResponse
    ](
      "putVoiceConnectorLoggingConfiguration",
      api.putVoiceConnectorLoggingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def searchAvailablePhoneNumbers(
        request: SearchAvailablePhoneNumbersRequest
    ): ZStream[Any, AwsError, E164PhoneNumber] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersRequest,
      SearchAvailablePhoneNumbersResponse,
      java.lang.String
    ](
      "searchAvailablePhoneNumbers",
      api.searchAvailablePhoneNumbers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.e164PhoneNumbers().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.chimesdkvoice.model.primitives.E164PhoneNumber(item))
      .provideEnvironment(r)
    def searchAvailablePhoneNumbersPaginated(
        request: SearchAvailablePhoneNumbersRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.SearchAvailablePhoneNumbersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersRequest,
      SearchAvailablePhoneNumbersResponse
    ]("searchAvailablePhoneNumbers", api.searchAvailablePhoneNumbers)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.SearchAvailablePhoneNumbersResponse.wrap)
      .provideEnvironment(r)
    def listVoiceProfileDomains(
        request: ListVoiceProfileDomainsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsRequest,
      ListVoiceProfileDomainsResponse,
      VoiceProfileDomainSummary
    ](
      "listVoiceProfileDomains",
      api.listVoiceProfileDomains,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.voiceProfileDomains().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listVoiceProfileDomainsPaginated(
        request: ListVoiceProfileDomainsRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.ListVoiceProfileDomainsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsRequest,
      ListVoiceProfileDomainsResponse
    ]("listVoiceProfileDomains", api.listVoiceProfileDomains)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.ListVoiceProfileDomainsResponse.wrap)
      .provideEnvironment(r)
    def listVoiceConnectorTerminationCredentials(
        request: ListVoiceConnectorTerminationCredentialsRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.ListVoiceConnectorTerminationCredentialsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorTerminationCredentialsRequest,
      ListVoiceConnectorTerminationCredentialsResponse
    ](
      "listVoiceConnectorTerminationCredentials",
      api.listVoiceConnectorTerminationCredentials
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.ListVoiceConnectorTerminationCredentialsResponse.wrap
      )
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chimesdkvoice.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def updateSipMediaApplication(
        request: UpdateSipMediaApplicationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipMediaApplicationRequest,
      UpdateSipMediaApplicationResponse
    ]("updateSipMediaApplication", api.updateSipMediaApplication)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationResponse.wrap)
      .provideEnvironment(r)
    def getSipRule(request: GetSipRuleRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chimesdkvoice.model.GetSipRuleRequest,
        GetSipRuleResponse
      ]("getSipRule", api.getSipRule)(request.buildAwsValue())
        .map(zio.aws.chimesdkvoice.model.GetSipRuleResponse.wrap)
        .provideEnvironment(r)
    def updatePhoneNumberSettings(
        request: UpdatePhoneNumberSettingsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberSettingsRequest,
      UpdatePhoneNumberSettingsResponse
    ]("updatePhoneNumberSettings", api.updatePhoneNumberSettings)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putSipMediaApplicationAlexaSkillConfiguration(
        request: PutSipMediaApplicationAlexaSkillConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationRequest,
      PutSipMediaApplicationAlexaSkillConfigurationResponse
    ](
      "putSipMediaApplicationAlexaSkillConfiguration",
      api.putSipMediaApplicationAlexaSkillConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def getVoiceConnectorStreamingConfiguration(
        request: GetVoiceConnectorStreamingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationRequest,
      GetVoiceConnectorStreamingConfigurationResponse
    ](
      "getVoiceConnectorStreamingConfiguration",
      api.getVoiceConnectorStreamingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def createVoiceConnectorGroup(
        request: CreateVoiceConnectorGroupRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorGroupRequest,
      CreateVoiceConnectorGroupResponse
    ]("createVoiceConnectorGroup", api.createVoiceConnectorGroup)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteProxySession(
        request: DeleteProxySessionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.DeleteProxySessionRequest,
      DeleteProxySessionResponse
    ]("deleteProxySession", api.deleteProxySession)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def startVoiceToneAnalysisTask(
        request: StartVoiceToneAnalysisTaskRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.StartVoiceToneAnalysisTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.StartVoiceToneAnalysisTaskRequest,
      StartVoiceToneAnalysisTaskResponse
    ]("startVoiceToneAnalysisTask", api.startVoiceToneAnalysisTask)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.StartVoiceToneAnalysisTaskResponse.wrap)
      .provideEnvironment(r)
    def getVoiceProfileDomain(request: GetVoiceProfileDomainRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetVoiceProfileDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileDomainRequest,
      GetVoiceProfileDomainResponse
    ]("getVoiceProfileDomain", api.getVoiceProfileDomain)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.GetVoiceProfileDomainResponse.wrap)
      .provideEnvironment(r)
    def listSipRules(
        request: ListSipRulesRequest
    ): ZStream[Any, AwsError, zio.aws.chimesdkvoice.model.SipRule.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesRequest,
        ListSipRulesResponse,
        SipRule
      ](
        "listSipRules",
        api.listSipRules,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.sipRules().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.chimesdkvoice.model.SipRule.wrap(item))
        .provideEnvironment(r)
    def listSipRulesPaginated(
        request: ListSipRulesRequest
    ): IO[AwsError, zio.aws.chimesdkvoice.model.ListSipRulesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesRequest,
        ListSipRulesResponse
      ]("listSipRules", api.listSipRules)(request.buildAwsValue())
        .map(zio.aws.chimesdkvoice.model.ListSipRulesResponse.wrap)
        .provideEnvironment(r)
    def getGlobalSettings(): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetGlobalSettingsResponse.ReadOnly
    ] =
      asyncRequestResponse[GetGlobalSettingsRequest, GetGlobalSettingsResponse](
        "getGlobalSettings",
        api.getGlobalSettings
      )(GetGlobalSettingsRequest.builder().build())
        .map(zio.aws.chimesdkvoice.model.GetGlobalSettingsResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def putVoiceConnectorTermination(
        request: PutVoiceConnectorTerminationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationRequest,
      PutVoiceConnectorTerminationResponse
    ]("putVoiceConnectorTermination", api.putVoiceConnectorTermination)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationResponse.wrap)
      .provideEnvironment(r)
    def associatePhoneNumbersWithVoiceConnectorGroup(
        request: AssociatePhoneNumbersWithVoiceConnectorGroupRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorGroupRequest,
      AssociatePhoneNumbersWithVoiceConnectorGroupResponse
    ](
      "associatePhoneNumbersWithVoiceConnectorGroup",
      api.associatePhoneNumbersWithVoiceConnectorGroup
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse.wrap
      )
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chimesdkvoice.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def batchDeletePhoneNumber(request: BatchDeletePhoneNumberRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.BatchDeletePhoneNumberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.BatchDeletePhoneNumberRequest,
      BatchDeletePhoneNumberResponse
    ]("batchDeletePhoneNumber", api.batchDeletePhoneNumber)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.BatchDeletePhoneNumberResponse.wrap)
      .provideEnvironment(r)
    def disassociatePhoneNumbersFromVoiceConnectorGroup(
        request: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest,
      DisassociatePhoneNumbersFromVoiceConnectorGroupResponse
    ](
      "disassociatePhoneNumbersFromVoiceConnectorGroup",
      api.disassociatePhoneNumbersFromVoiceConnectorGroup
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.wrap
      )
      .provideEnvironment(r)
    def putVoiceConnectorTerminationCredentials(
        request: PutVoiceConnectorTerminationCredentialsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationCredentialsRequest,
      PutVoiceConnectorTerminationCredentialsResponse
    ](
      "putVoiceConnectorTerminationCredentials",
      api.putVoiceConnectorTerminationCredentials
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createSipMediaApplicationCall(
        request: CreateSipMediaApplicationCallRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationCallRequest,
      CreateSipMediaApplicationCallResponse
    ]("createSipMediaApplicationCall", api.createSipMediaApplicationCall)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallResponse.wrap
    ).provideEnvironment(r)
    def getVoiceProfile(request: GetVoiceProfileRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetVoiceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileRequest,
      GetVoiceProfileResponse
    ]("getVoiceProfile", api.getVoiceProfile)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.GetVoiceProfileResponse.wrap)
      .provideEnvironment(r)
    def getVoiceConnectorLoggingConfiguration(
        request: GetVoiceConnectorLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationRequest,
      GetVoiceConnectorLoggingConfigurationResponse
    ](
      "getVoiceConnectorLoggingConfiguration",
      api.getVoiceConnectorLoggingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteVoiceProfileDomain(
        request: DeleteVoiceProfileDomainRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileDomainRequest,
      DeleteVoiceProfileDomainResponse
    ]("deleteVoiceProfileDomain", api.deleteVoiceProfileDomain)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteVoiceConnectorGroup(
        request: DeleteVoiceConnectorGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorGroupRequest,
      DeleteVoiceConnectorGroupResponse
    ]("deleteVoiceConnectorGroup", api.deleteVoiceConnectorGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putVoiceConnectorStreamingConfiguration(
        request: PutVoiceConnectorStreamingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationRequest,
      PutVoiceConnectorStreamingConfigurationResponse
    ](
      "putVoiceConnectorStreamingConfiguration",
      api.putVoiceConnectorStreamingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def getVoiceConnectorEmergencyCallingConfiguration(
        request: GetVoiceConnectorEmergencyCallingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationRequest,
      GetVoiceConnectorEmergencyCallingConfigurationResponse
    ](
      "getVoiceConnectorEmergencyCallingConfiguration",
      api.getVoiceConnectorEmergencyCallingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteVoiceConnectorTermination(
        request: DeleteVoiceConnectorTerminationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationRequest,
      DeleteVoiceConnectorTerminationResponse
    ]("deleteVoiceConnectorTermination", api.deleteVoiceConnectorTermination)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteVoiceConnectorStreamingConfiguration(
        request: DeleteVoiceConnectorStreamingConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorStreamingConfigurationRequest,
      DeleteVoiceConnectorStreamingConfigurationResponse
    ](
      "deleteVoiceConnectorStreamingConfiguration",
      api.deleteVoiceConnectorStreamingConfiguration
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putVoiceConnectorOrigination(
        request: PutVoiceConnectorOriginationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorOriginationRequest,
      PutVoiceConnectorOriginationResponse
    ]("putVoiceConnectorOrigination", api.putVoiceConnectorOrigination)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationResponse.wrap)
      .provideEnvironment(r)
    def stopSpeakerSearchTask(
        request: StopSpeakerSearchTaskRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.StopSpeakerSearchTaskRequest,
      StopSpeakerSearchTaskResponse
    ]("stopSpeakerSearchTask", api.stopSpeakerSearchTask)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getPhoneNumberSettings(): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetPhoneNumberSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetPhoneNumberSettingsRequest,
      GetPhoneNumberSettingsResponse
    ]("getPhoneNumberSettings", api.getPhoneNumberSettings)(
      GetPhoneNumberSettingsRequest.builder().build()
    ).map(zio.aws.chimesdkvoice.model.GetPhoneNumberSettingsResponse.wrap)
      .provideEnvironment(r)
    def updateProxySession(request: UpdateProxySessionRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.UpdateProxySessionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.UpdateProxySessionRequest,
      UpdateProxySessionResponse
    ]("updateProxySession", api.updateProxySession)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.UpdateProxySessionResponse.wrap)
      .provideEnvironment(r)
    def updateGlobalSettings(
        request: UpdateGlobalSettingsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.UpdateGlobalSettingsRequest,
      UpdateGlobalSettingsResponse
    ]("updateGlobalSettings", api.updateGlobalSettings)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listVoiceConnectorGroups(
        request: ListVoiceConnectorGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceConnectorGroup.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsRequest,
      ListVoiceConnectorGroupsResponse,
      VoiceConnectorGroup
    ](
      "listVoiceConnectorGroups",
      api.listVoiceConnectorGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.voiceConnectorGroups().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.chimesdkvoice.model.VoiceConnectorGroup.wrap(item))
      .provideEnvironment(r)
    def listVoiceConnectorGroupsPaginated(
        request: ListVoiceConnectorGroupsRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsRequest,
      ListVoiceConnectorGroupsResponse
    ]("listVoiceConnectorGroups", api.listVoiceConnectorGroups)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsResponse.wrap)
      .provideEnvironment(r)
    def createSipRule(request: CreateSipRuleRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.CreateSipRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.CreateSipRuleRequest,
      CreateSipRuleResponse
    ]("createSipRule", api.createSipRule)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.CreateSipRuleResponse.wrap)
      .provideEnvironment(r)
    def getVoiceConnectorGroup(request: GetVoiceConnectorGroupRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetVoiceConnectorGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorGroupRequest,
      GetVoiceConnectorGroupResponse
    ]("getVoiceConnectorGroup", api.getVoiceConnectorGroup)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.GetVoiceConnectorGroupResponse.wrap)
      .provideEnvironment(r)
    def createProxySession(request: CreateProxySessionRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.CreateProxySessionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.CreateProxySessionRequest,
      CreateProxySessionResponse
    ]("createProxySession", api.createProxySession)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.CreateProxySessionResponse.wrap)
      .provideEnvironment(r)
    def getVoiceConnectorOrigination(
        request: GetVoiceConnectorOriginationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorOriginationRequest,
      GetVoiceConnectorOriginationResponse
    ]("getVoiceConnectorOrigination", api.getVoiceConnectorOrigination)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationResponse.wrap)
      .provideEnvironment(r)
    def createSipMediaApplication(
        request: CreateSipMediaApplicationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.CreateSipMediaApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationRequest,
      CreateSipMediaApplicationResponse
    ]("createSipMediaApplication", api.createSipMediaApplication)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.CreateSipMediaApplicationResponse.wrap)
      .provideEnvironment(r)
    def createVoiceProfile(request: CreateVoiceProfileRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.CreateVoiceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileRequest,
      CreateVoiceProfileResponse
    ]("createVoiceProfile", api.createVoiceProfile)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.CreateVoiceProfileResponse.wrap)
      .provideEnvironment(r)
    def validateE911Address(request: ValidateE911AddressRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.ValidateE911AddressResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.ValidateE911AddressRequest,
      ValidateE911AddressResponse
    ]("validateE911Address", api.validateE911Address)(request.buildAwsValue())
      .map(zio.aws.chimesdkvoice.model.ValidateE911AddressResponse.wrap)
      .provideEnvironment(r)
    def deleteVoiceConnector(
        request: DeleteVoiceConnectorRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorRequest,
      DeleteVoiceConnectorResponse
    ]("deleteVoiceConnector", api.deleteVoiceConnector)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def batchUpdatePhoneNumber(request: BatchUpdatePhoneNumberRequest): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.BatchUpdatePhoneNumberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.BatchUpdatePhoneNumberRequest,
      BatchUpdatePhoneNumberResponse
    ]("batchUpdatePhoneNumber", api.batchUpdatePhoneNumber)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkvoice.model.BatchUpdatePhoneNumberResponse.wrap)
      .provideEnvironment(r)
    def getSipMediaApplicationAlexaSkillConfiguration(
        request: GetSipMediaApplicationAlexaSkillConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationRequest,
      GetSipMediaApplicationAlexaSkillConfigurationResponse
    ](
      "getSipMediaApplicationAlexaSkillConfiguration",
      api.getSipMediaApplicationAlexaSkillConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationResponse.wrap
      )
      .provideEnvironment(r)
  }
  def listSipMediaApplications(
      request: ListSipMediaApplicationsRequest
  ): ZStream[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly
  ] = ZStream.serviceWithStream(_.listSipMediaApplications(request))
  def listSipMediaApplicationsPaginated(
      request: ListSipMediaApplicationsRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.ListSipMediaApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSipMediaApplicationsPaginated(request))
  def deleteVoiceProfile(
      request: DeleteVoiceProfileRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceProfile(request))
  def putVoiceConnectorEmergencyCallingConfiguration(
      request: PutVoiceConnectorEmergencyCallingConfigurationRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.putVoiceConnectorEmergencyCallingConfiguration(request)
  )
  def deleteSipRule(
      request: DeleteSipRuleRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSipRule(request))
  def putVoiceConnectorProxy(request: PutVoiceConnectorProxyRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putVoiceConnectorProxy(request))
  def createVoiceConnector(request: CreateVoiceConnectorRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.CreateVoiceConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVoiceConnector(request))
  def restorePhoneNumber(request: RestorePhoneNumberRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.RestorePhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restorePhoneNumber(request))
  def putSipMediaApplicationLoggingConfiguration(
      request: PutSipMediaApplicationLoggingConfigurationRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putSipMediaApplicationLoggingConfiguration(request))
  def getVoiceConnector(request: GetVoiceConnectorRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnector(request))
  def disassociatePhoneNumbersFromVoiceConnector(
      request: DisassociatePhoneNumbersFromVoiceConnectorRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociatePhoneNumbersFromVoiceConnector(request))
  def updateVoiceConnectorGroup(request: UpdateVoiceConnectorGroupRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVoiceConnectorGroup(request))
  def listSupportedPhoneNumberCountries(
      request: ListSupportedPhoneNumberCountriesRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSupportedPhoneNumberCountries(request))
  def getVoiceConnectorProxy(request: GetVoiceConnectorProxyRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnectorProxy(request))
  def listVoiceConnectors(request: ListVoiceConnectorsRequest): ZStream[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly
  ] = ZStream.serviceWithStream(_.listVoiceConnectors(request))
  def listVoiceConnectorsPaginated(request: ListVoiceConnectorsRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.ListVoiceConnectorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVoiceConnectorsPaginated(request))
  def createVoiceProfileDomain(request: CreateVoiceProfileDomainRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.CreateVoiceProfileDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVoiceProfileDomain(request))
  def getVoiceToneAnalysisTask(request: GetVoiceToneAnalysisTaskRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceToneAnalysisTask(request))
  def updateSipRule(request: UpdateSipRuleRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.UpdateSipRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSipRule(request))
  def listAvailableVoiceConnectorRegions(): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAvailableVoiceConnectorRegions())
  def getVoiceConnectorTermination(
      request: GetVoiceConnectorTerminationRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnectorTermination(request))
  def associatePhoneNumbersWithVoiceConnector(
      request: AssociatePhoneNumbersWithVoiceConnectorRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associatePhoneNumbersWithVoiceConnector(request))
  def createPhoneNumberOrder(request: CreatePhoneNumberOrderRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPhoneNumberOrder(request))
  def deleteVoiceConnectorEmergencyCallingConfiguration(
      request: DeleteVoiceConnectorEmergencyCallingConfigurationRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(
      _.deleteVoiceConnectorEmergencyCallingConfiguration(request)
    )
  def getSipMediaApplicationLoggingConfiguration(
      request: GetSipMediaApplicationLoggingConfigurationRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSipMediaApplicationLoggingConfiguration(request))
  def getProxySession(request: GetProxySessionRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetProxySessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getProxySession(request))
  def deletePhoneNumber(
      request: DeletePhoneNumberRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePhoneNumber(request))
  def listPhoneNumberOrders(request: ListPhoneNumberOrdersRequest): ZStream[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.PhoneNumberOrder.ReadOnly
  ] = ZStream.serviceWithStream(_.listPhoneNumberOrders(request))
  def listPhoneNumberOrdersPaginated(
      request: ListPhoneNumberOrdersRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.ListPhoneNumberOrdersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPhoneNumberOrdersPaginated(request))
  def getSpeakerSearchTask(request: GetSpeakerSearchTaskRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSpeakerSearchTask(request))
  def listVoiceProfiles(request: ListVoiceProfilesRequest): ZStream[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.VoiceProfileSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listVoiceProfiles(request))
  def listVoiceProfilesPaginated(request: ListVoiceProfilesRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.ListVoiceProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVoiceProfilesPaginated(request))
  def deleteSipMediaApplication(
      request: DeleteSipMediaApplicationRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSipMediaApplication(request))
  def listProxySessions(request: ListProxySessionsRequest): ZStream[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.ProxySession.ReadOnly
  ] = ZStream.serviceWithStream(_.listProxySessions(request))
  def listProxySessionsPaginated(request: ListProxySessionsRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.ListProxySessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProxySessionsPaginated(request))
  def deleteVoiceConnectorProxy(
      request: DeleteVoiceConnectorProxyRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceConnectorProxy(request))
  def startSpeakerSearchTask(request: StartSpeakerSearchTaskRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startSpeakerSearchTask(request))
  def getPhoneNumberOrder(request: GetPhoneNumberOrderRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetPhoneNumberOrderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPhoneNumberOrder(request))
  def updateVoiceConnector(request: UpdateVoiceConnectorRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.UpdateVoiceConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVoiceConnector(request))
  def getSipMediaApplication(request: GetSipMediaApplicationRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetSipMediaApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSipMediaApplication(request))
  def stopVoiceToneAnalysisTask(
      request: StopVoiceToneAnalysisTaskRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopVoiceToneAnalysisTask(request))
  def updateSipMediaApplicationCall(
      request: UpdateSipMediaApplicationCallRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSipMediaApplicationCall(request))
  def updateVoiceProfile(request: UpdateVoiceProfileRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.UpdateVoiceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVoiceProfile(request))
  def deleteVoiceConnectorOrigination(
      request: DeleteVoiceConnectorOriginationRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceConnectorOrigination(request))
  def listPhoneNumbers(request: ListPhoneNumbersRequest): ZStream[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly
  ] = ZStream.serviceWithStream(_.listPhoneNumbers(request))
  def listPhoneNumbersPaginated(request: ListPhoneNumbersRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.ListPhoneNumbersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPhoneNumbersPaginated(request))
  def deleteVoiceConnectorTerminationCredentials(
      request: DeleteVoiceConnectorTerminationCredentialsRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceConnectorTerminationCredentials(request))
  def updatePhoneNumber(request: UpdatePhoneNumberRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.UpdatePhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePhoneNumber(request))
  def updateVoiceProfileDomain(request: UpdateVoiceProfileDomainRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.UpdateVoiceProfileDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVoiceProfileDomain(request))
  def getVoiceConnectorTerminationHealth(
      request: GetVoiceConnectorTerminationHealthRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnectorTerminationHealth(request))
  def getPhoneNumber(request: GetPhoneNumberRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetPhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPhoneNumber(request))
  def putVoiceConnectorLoggingConfiguration(
      request: PutVoiceConnectorLoggingConfigurationRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putVoiceConnectorLoggingConfiguration(request))
  def searchAvailablePhoneNumbers(
      request: SearchAvailablePhoneNumbersRequest
  ): ZStream[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, E164PhoneNumber] =
    ZStream.serviceWithStream(_.searchAvailablePhoneNumbers(request))
  def searchAvailablePhoneNumbersPaginated(
      request: SearchAvailablePhoneNumbersRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.SearchAvailablePhoneNumbersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchAvailablePhoneNumbersPaginated(request))
  def listVoiceProfileDomains(request: ListVoiceProfileDomainsRequest): ZStream[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listVoiceProfileDomains(request))
  def listVoiceProfileDomainsPaginated(
      request: ListVoiceProfileDomainsRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.ListVoiceProfileDomainsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVoiceProfileDomainsPaginated(request))
  def listVoiceConnectorTerminationCredentials(
      request: ListVoiceConnectorTerminationCredentialsRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.ListVoiceConnectorTerminationCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVoiceConnectorTerminationCredentials(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def updateSipMediaApplication(request: UpdateSipMediaApplicationRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSipMediaApplication(request))
  def getSipRule(
      request: GetSipRuleRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getSipRule(request))
  def updatePhoneNumberSettings(
      request: UpdatePhoneNumberSettingsRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updatePhoneNumberSettings(request))
  def putSipMediaApplicationAlexaSkillConfiguration(
      request: PutSipMediaApplicationAlexaSkillConfigurationRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.putSipMediaApplicationAlexaSkillConfiguration(request))
  def getVoiceConnectorStreamingConfiguration(
      request: GetVoiceConnectorStreamingConfigurationRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnectorStreamingConfiguration(request))
  def createVoiceConnectorGroup(request: CreateVoiceConnectorGroupRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVoiceConnectorGroup(request))
  def deleteProxySession(
      request: DeleteProxySessionRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteProxySession(request))
  def startVoiceToneAnalysisTask(
      request: StartVoiceToneAnalysisTaskRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.StartVoiceToneAnalysisTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startVoiceToneAnalysisTask(request))
  def getVoiceProfileDomain(request: GetVoiceProfileDomainRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceProfileDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceProfileDomain(request))
  def listSipRules(request: ListSipRulesRequest): ZStream[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.SipRule.ReadOnly
  ] = ZStream.serviceWithStream(_.listSipRules(request))
  def listSipRulesPaginated(request: ListSipRulesRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.ListSipRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSipRulesPaginated(request))
  def getGlobalSettings(): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetGlobalSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGlobalSettings())
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def putVoiceConnectorTermination(
      request: PutVoiceConnectorTerminationRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putVoiceConnectorTermination(request))
  def associatePhoneNumbersWithVoiceConnectorGroup(
      request: AssociatePhoneNumbersWithVoiceConnectorGroupRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.associatePhoneNumbersWithVoiceConnectorGroup(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def batchDeletePhoneNumber(request: BatchDeletePhoneNumberRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.BatchDeletePhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDeletePhoneNumber(request))
  def disassociatePhoneNumbersFromVoiceConnectorGroup(
      request: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.disassociatePhoneNumbersFromVoiceConnectorGroup(request)
  )
  def putVoiceConnectorTerminationCredentials(
      request: PutVoiceConnectorTerminationCredentialsRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putVoiceConnectorTerminationCredentials(request))
  def createSipMediaApplicationCall(
      request: CreateSipMediaApplicationCallRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSipMediaApplicationCall(request))
  def getVoiceProfile(request: GetVoiceProfileRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceProfile(request))
  def getVoiceConnectorLoggingConfiguration(
      request: GetVoiceConnectorLoggingConfigurationRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnectorLoggingConfiguration(request))
  def deleteVoiceProfileDomain(
      request: DeleteVoiceProfileDomainRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceProfileDomain(request))
  def deleteVoiceConnectorGroup(
      request: DeleteVoiceConnectorGroupRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceConnectorGroup(request))
  def putVoiceConnectorStreamingConfiguration(
      request: PutVoiceConnectorStreamingConfigurationRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putVoiceConnectorStreamingConfiguration(request))
  def getVoiceConnectorEmergencyCallingConfiguration(
      request: GetVoiceConnectorEmergencyCallingConfigurationRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getVoiceConnectorEmergencyCallingConfiguration(request)
  )
  def deleteVoiceConnectorTermination(
      request: DeleteVoiceConnectorTerminationRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceConnectorTermination(request))
  def deleteVoiceConnectorStreamingConfiguration(
      request: DeleteVoiceConnectorStreamingConfigurationRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceConnectorStreamingConfiguration(request))
  def putVoiceConnectorOrigination(
      request: PutVoiceConnectorOriginationRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putVoiceConnectorOrigination(request))
  def stopSpeakerSearchTask(
      request: StopSpeakerSearchTaskRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopSpeakerSearchTask(request))
  def getPhoneNumberSettings(): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetPhoneNumberSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPhoneNumberSettings())
  def updateProxySession(request: UpdateProxySessionRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.UpdateProxySessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProxySession(request))
  def updateGlobalSettings(
      request: UpdateGlobalSettingsRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateGlobalSettings(request))
  def listVoiceConnectorGroups(
      request: ListVoiceConnectorGroupsRequest
  ): ZStream[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.VoiceConnectorGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.listVoiceConnectorGroups(request))
  def listVoiceConnectorGroupsPaginated(
      request: ListVoiceConnectorGroupsRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVoiceConnectorGroupsPaginated(request))
  def createSipRule(request: CreateSipRuleRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.CreateSipRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSipRule(request))
  def getVoiceConnectorGroup(request: GetVoiceConnectorGroupRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnectorGroup(request))
  def createProxySession(request: CreateProxySessionRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.CreateProxySessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProxySession(request))
  def getVoiceConnectorOrigination(
      request: GetVoiceConnectorOriginationRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnectorOrigination(request))
  def createSipMediaApplication(request: CreateSipMediaApplicationRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.CreateSipMediaApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSipMediaApplication(request))
  def createVoiceProfile(request: CreateVoiceProfileRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.CreateVoiceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVoiceProfile(request))
  def validateE911Address(request: ValidateE911AddressRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.ValidateE911AddressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.validateE911Address(request))
  def deleteVoiceConnector(
      request: DeleteVoiceConnectorRequest
  ): ZIO[zio.aws.chimesdkvoice.ChimeSdkVoice, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceConnector(request))
  def batchUpdatePhoneNumber(request: BatchUpdatePhoneNumberRequest): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.BatchUpdatePhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchUpdatePhoneNumber(request))
  def getSipMediaApplicationAlexaSkillConfiguration(
      request: GetSipMediaApplicationAlexaSkillConfigurationRequest
  ): ZIO[
    zio.aws.chimesdkvoice.ChimeSdkVoice,
    AwsError,
    zio.aws.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.getSipMediaApplicationAlexaSkillConfiguration(request))
}
