package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateVoiceProfileResponse(
    voiceProfile: Optional[zio.aws.chimesdkvoice.model.VoiceProfile] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileResponse = {
    import UpdateVoiceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileResponse
      .builder()
      .optionallyWith(voiceProfile.map(value => value.buildAwsValue()))(
        _.voiceProfile
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.UpdateVoiceProfileResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.UpdateVoiceProfileResponse.wrap(buildAwsValue())
}
object UpdateVoiceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.UpdateVoiceProfileResponse =
      zio.aws.chimesdkvoice.model
        .UpdateVoiceProfileResponse(voiceProfile.map(value => value.asEditable))
    def voiceProfile
        : Optional[zio.aws.chimesdkvoice.model.VoiceProfile.ReadOnly]
    def getVoiceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("voiceProfile", voiceProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileResponse
  ) extends zio.aws.chimesdkvoice.model.UpdateVoiceProfileResponse.ReadOnly {
    override val voiceProfile
        : Optional[zio.aws.chimesdkvoice.model.VoiceProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceProfile())
        .map(value => zio.aws.chimesdkvoice.model.VoiceProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileResponse
  ): zio.aws.chimesdkvoice.model.UpdateVoiceProfileResponse.ReadOnly =
    new Wrapper(impl)
}
