package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.{
  VoiceConnectorGroupName,
  NonEmptyString
}
import scala.jdk.CollectionConverters._
final case class UpdateVoiceConnectorGroupRequest(
    voiceConnectorGroupId: NonEmptyString,
    name: VoiceConnectorGroupName,
    voiceConnectorItems: Iterable[
      zio.aws.chimesdkvoice.model.VoiceConnectorItem
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorGroupRequest = {
    import UpdateVoiceConnectorGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorGroupRequest
      .builder()
      .voiceConnectorGroupId(
        NonEmptyString.unwrap(voiceConnectorGroupId): java.lang.String
      )
      .name(VoiceConnectorGroupName.unwrap(name): java.lang.String)
      .voiceConnectorItems(voiceConnectorItems.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupRequest
      .wrap(buildAwsValue())
}
object UpdateVoiceConnectorGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupRequest =
      zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupRequest(
        voiceConnectorGroupId,
        name,
        voiceConnectorItems.map { item =>
          item.asEditable
        }
      )
    def voiceConnectorGroupId: NonEmptyString
    def name: VoiceConnectorGroupName
    def voiceConnectorItems
        : List[zio.aws.chimesdkvoice.model.VoiceConnectorItem.ReadOnly]
    def getVoiceConnectorGroupId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorGroupId)
    def getName: ZIO[Any, Nothing, VoiceConnectorGroupName] = ZIO.succeed(name)
    def getVoiceConnectorItems: ZIO[Any, Nothing, List[
      zio.aws.chimesdkvoice.model.VoiceConnectorItem.ReadOnly
    ]] = ZIO.succeed(voiceConnectorItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorGroupRequest
  ) extends zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupRequest.ReadOnly {
    override val voiceConnectorGroupId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorGroupId())
    override val name: VoiceConnectorGroupName =
      zio.aws.chimesdkvoice.model.primitives
        .VoiceConnectorGroupName(impl.name())
    override val voiceConnectorItems
        : List[zio.aws.chimesdkvoice.model.VoiceConnectorItem.ReadOnly] = impl
      .voiceConnectorItems()
      .asScala
      .map { item =>
        zio.aws.chimesdkvoice.model.VoiceConnectorItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorGroupRequest
  ): zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupRequest.ReadOnly =
    new Wrapper(impl)
}
