package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.{
  CallingName,
  SensitiveNonEmptyString
}
import scala.jdk.CollectionConverters._
final case class UpdatePhoneNumberRequest(
    phoneNumberId: SensitiveNonEmptyString,
    productType: Optional[zio.aws.chimesdkvoice.model.PhoneNumberProductType] =
      Optional.Absent,
    callingName: Optional[CallingName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequest = {
    import UpdatePhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequest
      .builder()
      .phoneNumberId(
        SensitiveNonEmptyString.unwrap(phoneNumberId): java.lang.String
      )
      .optionallyWith(productType.map(value => value.unwrap))(_.productType)
      .optionallyWith(
        callingName.map(value => CallingName.unwrap(value): java.lang.String)
      )(_.callingName)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequest.wrap(buildAwsValue())
}
object UpdatePhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequest =
      zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequest(
        phoneNumberId,
        productType.map(value => value),
        callingName.map(value => value)
      )
    def phoneNumberId: SensitiveNonEmptyString
    def productType
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberProductType]
    def callingName: Optional[CallingName]
    def getPhoneNumberId: ZIO[Any, Nothing, SensitiveNonEmptyString] =
      ZIO.succeed(phoneNumberId)
    def getProductType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.PhoneNumberProductType
    ] = AwsError.unwrapOptionField("productType", productType)
    def getCallingName: ZIO[Any, AwsError, CallingName] =
      AwsError.unwrapOptionField("callingName", callingName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequest
  ) extends zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequest.ReadOnly {
    override val phoneNumberId: SensitiveNonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .SensitiveNonEmptyString(impl.phoneNumberId())
    override val productType
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberProductType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productType())
        .map(value =>
          zio.aws.chimesdkvoice.model.PhoneNumberProductType.wrap(value)
        )
    override val callingName: Optional[CallingName] = zio.aws.core.internal
      .optionalFromNullable(impl.callingName())
      .map(value => zio.aws.chimesdkvoice.model.primitives.CallingName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequest
  ): zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequest.ReadOnly =
    new Wrapper(impl)
}
